/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.mylyn.context.ui.AbstractAutoFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.navigator.FilterSelectionAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.ui.views.navigator.ToggleLinkingAction;

public class FocusResourceNavigatorAction
extends AbstractAutoFocusViewAction {
    public FocusResourceNavigatorAction() {
        super(new InterestFilter(), true, true, true);
    }

    public List<StructuredViewer> getViewers() {
        ArrayList<StructuredViewer> viewers = new ArrayList<StructuredViewer>();
        IViewPart part = super.getPartForAction();
        if (part instanceof ResourceNavigator) {
            viewers.add((StructuredViewer)((ResourceNavigator)part).getTreeViewer());
        }
        return viewers;
    }

    protected ISelection resolveSelection(IEditorPart part, ITextSelection changedSelection, StructuredViewer viewer) throws CoreException {
        IEditorInput input = part.getEditorInput();
        Object adapted = input.getAdapter(IResource.class);
        if (adapted instanceof IResource) {
            return new StructuredSelection(adapted);
        }
        return null;
    }

    protected void setManualFilteringAndLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof IResourceNavigator) {
            ActionContributionItem actionItem;
            IContributionItem item;
            IContributionItem[] iContributionItemArray = ((IResourceNavigator)part).getViewSite().getActionBars().getToolBarManager().getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (actionItem = (ActionContributionItem)item).getAction() instanceof ToggleLinkingAction) {
                    actionItem.getAction().setEnabled(on);
                }
                ++n2;
            }
            iContributionItemArray = ((IResourceNavigator)part).getViewSite().getActionBars().getMenuManager().getItems();
            n = iContributionItemArray.length;
            n2 = 0;
            while (n2 < n) {
                item = iContributionItemArray[n2];
                if (item instanceof ActionContributionItem && (actionItem = (ActionContributionItem)item).getAction() instanceof FilterSelectionAction) {
                    actionItem.getAction().setEnabled(on);
                }
                ++n2;
            }
        }
    }

    protected void setDefaultLinkingEnabled(boolean on) {
        IViewPart part = super.getPartForAction();
        if (part instanceof IResourceNavigator) {
            ((IResourceNavigator)part).setLinkingEnabled(on);
        }
    }

    protected boolean isDefaultLinkingEnabled() {
        IViewPart part = super.getPartForAction();
        if (part instanceof IResourceNavigator) {
            return ((IResourceNavigator)part).isLinkingEnabled();
        }
        return false;
    }
}

