/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.AndPattern;

public class TypeReferencePattern
extends AndPattern
implements IIndexConstants {
    public char[] qualification;
    public char[] simpleName;
    protected char[] currentCategory;
    public int segmentsSize;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{REF};

    public TypeReferencePattern(char[] qualification, char[] simpleName, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        char[] cArray = this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.segments = (char[][])(simpleName == null ? (this.qualification == null ? ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification)) : null);
        this.segmentsSize = this.segments == null ? (this.qualification == null ? 0 : CharOperation.occurencesOf('.', this.qualification) + 1) : this.segments.length;
    }

    public TypeReferencePattern(char[] qualification, char[] simpleName, IType type, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(qualification, simpleName, matchRule, toolkit);
    }

    TypeReferencePattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(4, matchRule, toolkit);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        this.simpleName = key;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new TypeReferencePattern(8, this.getToolkit());
    }

    @Override
    public char[] getIndexKey() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    @Override
    public boolean hasNextQuery() {
        if (this.segments == null) {
            return false;
        }
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    @Override
    public void resetQuery() {
        if (this.segments != null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    @Override
    protected StringBuilder print(StringBuilder output) {
        output.append("TypeReferencePattern: qualification<");
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

