/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.profile;

import org.eclipse.datatools.connectivity.ConnectionProfileConstants;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.VersionProviderConnection;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaDriver;
import org.eclipse.datatools.connectivity.oda.profile.Constants;
import org.eclipse.datatools.connectivity.oda.profile.OdaConnectionFactory;

public class OdaConnectionWrapper
extends VersionProviderConnection {
    private static final String EMPTY_STR = "";
    private static final Version ODA_UNKNOWN_VERSION = new Version(3, 0, 0, ""){

        public String toString() {
            return ConnectionProfileConstants.UNKNOWN_VERSION;
        }
    };
    private String m_odaDataSourceId;
    private IConnection m_odaConnectionHelper;
    private IDriver m_odaDriverHelper;
    private IDataSetMetaData m_odaMetadataHelper;
    private Exception m_connectException;

    public OdaConnectionWrapper(IConnectionProfile profile) {
        super(profile, OdaConnectionFactory.class);
        this.m_odaDataSourceId = profile.getProviderId();
        try {
            this.getOdaConnectionHelper(this.m_odaDataSourceId);
            assert (this.m_odaConnectionHelper != null);
            this.open();
            this.m_connectException = null;
        }
        catch (OdaException ex) {
            this.m_connectException = ex;
            this.clearVersionCache();
            return;
        }
        try {
            this.m_odaMetadataHelper = this.m_odaConnectionHelper.getMetaData(EMPTY_STR);
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
        if (!this.canProvideVersionMetaData()) {
            this.m_odaMetadataHelper = null;
        }
        this.updateVersionCache();
    }

    public Object getRawConnection() {
        return this.m_odaConnectionHelper;
    }

    public void close() {
        if (this.getRawConnection() == null) {
            return;
        }
        try {
            this.m_odaConnectionHelper.close();
            this.m_odaMetadataHelper = null;
            this.m_connectException = null;
        }
        catch (OdaException odaException) {}
    }

    public Throwable getConnectException() {
        return this.m_connectException;
    }

    protected String getTechnologyRootKey() {
        if (this.m_odaDataSourceId == null || this.m_odaDataSourceId.length() == 0) {
            return ((Object)((Object)this)).getClass().getName();
        }
        return this.m_odaDataSourceId;
    }

    public Version getProviderVersion() {
        if (this.m_odaMetadataHelper == null) {
            return ODA_UNKNOWN_VERSION;
        }
        try {
            return Version.valueOf((String)this.m_odaMetadataHelper.getDataSourceProductVersion());
        }
        catch (OdaException e) {
            e.printStackTrace();
            return ODA_UNKNOWN_VERSION;
        }
    }

    public String getProviderName() {
        if (this.m_odaMetadataHelper == null) {
            return EMPTY_STR;
        }
        try {
            return this.m_odaMetadataHelper.getDataSourceProductName();
        }
        catch (OdaException odaException) {
            return this.getTechnologyRootKey();
        }
    }

    public Version getTechnologyVersion() {
        return Version.valueOf((String)"3.0.6");
    }

    public String getTechnologyName() {
        return Constants.ODA_COMPONENT_NAME;
    }

    public void open() throws OdaException {
        IConnection odaConn = this.m_odaConnectionHelper;
        assert (odaConn != null);
        try {
            odaConn.open(this.getConnectionProfile().getBaseProperties());
        }
        catch (Throwable ex) {
            if (ex instanceof OdaException) {
                throw (OdaException)ex;
            }
            throw new OdaException(ex);
        }
    }

    private IConnection getOdaConnectionHelper(String odaDataSourceElementId) throws OdaException {
        if (this.m_odaConnectionHelper != null) {
            return this.m_odaConnectionHelper;
        }
        IDriver odaDriver = this.getOdaDriverHelper(odaDataSourceElementId);
        assert (odaDriver != null);
        this.m_odaConnectionHelper = odaDriver.getConnection(odaDataSourceElementId);
        return this.m_odaConnectionHelper;
    }

    private IDriver getOdaDriverHelper(String odaDataSourceElementId) throws OdaException {
        if (this.m_odaDriverHelper == null) {
            this.m_odaDriverHelper = new OdaDriver(odaDataSourceElementId);
        }
        return this.m_odaDriverHelper;
    }

    private boolean canProvideVersionMetaData() {
        if (this.m_odaMetadataHelper == null) {
            return false;
        }
        try {
            this.getProviderVersion();
            this.getProviderName();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }
}

