/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class ChunkByteIterable
extends AbstractLazyIterable<ByteIterable> {
    private final ByteIterable adapted;
    private final int size;

    public ChunkByteIterable(ByteIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<ByteIterable> iterator() {
        return new ChunkByteIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super ByteIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkByteIterator
    implements Iterator<ByteIterable> {
        private final ByteIterator iterator;
        private final int size;
        private final Function0<MutableByteCollection> speciesNewStrategy;

        public ChunkByteIterator(ByteIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.byteIterator();
            this.speciesNewStrategy = iterable instanceof MutableByteCollection ? ((MutableByteCollection)iterable)::newEmpty : ByteLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ByteIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableByteCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

