/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.CaConfig;
import org.mandas.docker.client.messages.swarm.DispatcherConfig;
import org.mandas.docker.client.messages.swarm.EncryptionConfig;
import org.mandas.docker.client.messages.swarm.ImmutableSwarmSpec;
import org.mandas.docker.client.messages.swarm.OrchestrationConfig;
import org.mandas.docker.client.messages.swarm.RaftConfig;
import org.mandas.docker.client.messages.swarm.TaskDefaults;

@JsonDeserialize(builder=ImmutableSwarmSpec.Builder.class)
@Value.Immutable
public interface SwarmSpec {
    @JsonProperty(value="Name")
    @Nullable
    public String name();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="Orchestration")
    @Nullable
    public OrchestrationConfig orchestration();

    @JsonProperty(value="Raft")
    @Nullable
    public RaftConfig raft();

    @JsonProperty(value="Dispatcher")
    @Nullable
    public DispatcherConfig dispatcher();

    @JsonProperty(value="CAConfig")
    @Nullable
    public CaConfig caConfig();

    @JsonProperty(value="EncryptionConfig")
    @Nullable
    public EncryptionConfig encryptionConfig();

    @JsonProperty(value="TaskDefaults")
    @Nullable
    public TaskDefaults taskDefaults();

    public static Builder builder() {
        return ImmutableSwarmSpec.builder();
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder labels(Map<String, ? extends String> var1);

        public Builder orchestration(OrchestrationConfig var1);

        public Builder raft(RaftConfig var1);

        public Builder dispatcher(DispatcherConfig var1);

        public Builder caConfig(CaConfig var1);

        public Builder encryptionConfig(EncryptionConfig var1);

        public Builder taskDefaults(TaskDefaults var1);

        public SwarmSpec build();
    }
}

