/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.TestIdentifier;

@API(status=API.Status.STABLE, since="1.0")
public class TestPlan {
    private final Set<TestIdentifier> roots = Collections.synchronizedSet(new LinkedHashSet(4));
    private final Map<UniqueId, Set<TestIdentifier>> children = new ConcurrentHashMap<UniqueId, Set<TestIdentifier>>(32);
    private final Map<UniqueId, TestIdentifier> allIdentifiers = new ConcurrentHashMap<UniqueId, TestIdentifier>(32);
    private final boolean containsTests;
    private final ConfigurationParameters configurationParameters;

    @API(status=API.Status.INTERNAL, since="1.0")
    public static TestPlan from(Collection<TestDescriptor> engineDescriptors, ConfigurationParameters configurationParameters) {
        Preconditions.notNull(engineDescriptors, (String)"Cannot create TestPlan from a null collection of TestDescriptors");
        Preconditions.notNull((Object)configurationParameters, (String)"Cannot create TestPlan from null ConfigurationParameters");
        TestPlan testPlan = new TestPlan(engineDescriptors.stream().anyMatch(TestDescriptor::containsTests), configurationParameters);
        TestDescriptor.Visitor visitor = descriptor -> testPlan.addInternal(TestIdentifier.from(descriptor));
        engineDescriptors.forEach(engineDescriptor -> engineDescriptor.accept(visitor));
        return testPlan;
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    protected TestPlan(boolean containsTests, ConfigurationParameters configurationParameters) {
        this.containsTests = containsTests;
        this.configurationParameters = configurationParameters;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.4")
    public void add(TestIdentifier testIdentifier) {
        throw new JUnitException("Unsupported attempt to modify the TestPlan was detected. Please contact your IDE/tool vendor and request a fix or downgrade to JUnit 5.7.x (see https://github.com/junit-team/junit5/issues/1732 for details).");
    }

    @API(status=API.Status.INTERNAL, since="1.8")
    public void addInternal(TestIdentifier testIdentifier) {
        Preconditions.notNull((Object)testIdentifier, (String)"testIdentifier must not be null");
        this.allIdentifiers.put(testIdentifier.getUniqueIdObject(), testIdentifier);
        if (testIdentifier.getParentIdObject().isPresent()) {
            UniqueId parentId = testIdentifier.getParentIdObject().get();
            Set directChildren = this.children.computeIfAbsent(parentId, key -> Collections.synchronizedSet(new LinkedHashSet(16)));
            directChildren.add(testIdentifier);
        } else {
            this.roots.add(testIdentifier);
        }
    }

    public Set<TestIdentifier> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        Preconditions.notNull((Object)child, (String)"child must not be null");
        return child.getParentId().map(this::getTestIdentifier);
    }

    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        Preconditions.notNull((Object)parent, (String)"parent must not be null");
        return this.getChildren(parent.getUniqueId());
    }

    public Set<TestIdentifier> getChildren(String parentId) {
        Preconditions.notBlank((String)parentId, (String)"parent ID must not be null or blank");
        UniqueId uniqueId = UniqueId.parse((String)parentId);
        return this.children.containsKey(uniqueId) ? Collections.unmodifiableSet(this.children.get(uniqueId)) : Collections.emptySet();
    }

    public TestIdentifier getTestIdentifier(String uniqueId) throws PreconditionViolationException {
        Preconditions.notBlank((String)uniqueId, (String)"unique ID must not be null or blank");
        UniqueId uniqueIdObject = UniqueId.parse((String)uniqueId);
        Preconditions.condition((boolean)this.allIdentifiers.containsKey(uniqueIdObject), () -> "No TestIdentifier with unique ID [" + uniqueId + "] has been added to this TestPlan.");
        return this.allIdentifiers.get(uniqueIdObject);
    }

    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        Preconditions.notNull(predicate, (String)"Predicate must not be null");
        return this.allIdentifiers.values().stream().filter(predicate).count();
    }

    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        Preconditions.notNull((Object)parent, (String)"parent must not be null");
        LinkedHashSet<TestIdentifier> result = new LinkedHashSet<TestIdentifier>(16);
        Set<TestIdentifier> children = this.getChildren(parent);
        result.addAll(children);
        for (TestIdentifier child : children) {
            result.addAll(this.getDescendants(child));
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean containsTests() {
        return this.containsTests;
    }

    @API(status=API.Status.MAINTAINED, since="1.8")
    public ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }
}

