/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.progress;

import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.progress.ProgressListener;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationMetadata;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.time.Clock;
import org.gradle.util.GUtil;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final Clock clock;
    private final BuildOperationIdFactory buildOperationIdFactory;
    private final ThreadLocal<ProgressLoggerImpl> current = new ThreadLocal();
    private final CurrentBuildOperationRef currentBuildOperationRef = CurrentBuildOperationRef.instance();

    public DefaultProgressLoggerFactory(ProgressListener progressListener, Clock clock, BuildOperationIdFactory buildOperationIdFactory) {
        this.progressListener = progressListener;
        this.clock = clock;
        this.buildOperationIdFactory = buildOperationIdFactory;
    }

    @Override
    public ProgressLogger newOperation(Class<?> loggerCategory) {
        return this.newOperation(loggerCategory.getName());
    }

    @Override
    public ProgressLogger newOperation(Class<?> loggerCategory, BuildOperationDescriptor buildOperationDescriptor) {
        BuildOperationCategory buildOperationCategory;
        String category = "org.gradle.internal.logging.progress.ProgressLoggerFactory";
        BuildOperationMetadata metadata = buildOperationDescriptor.getMetadata();
        BuildOperationCategory buildOperationCategory2 = buildOperationCategory = metadata == BuildOperationMetadata.NONE ? BuildOperationCategory.UNCATEGORIZED : (BuildOperationCategory)metadata;
        if (buildOperationCategory == BuildOperationCategory.TASK) {
            category = "class org.gradle.internal.buildevents.TaskExecutionLogger";
        }
        ProgressLoggerImpl logger = new ProgressLoggerImpl(null, buildOperationDescriptor.getId(), category, this.progressListener, this.clock, true, buildOperationDescriptor.getId(), buildOperationDescriptor.getParentId(), buildOperationCategory);
        logger.totalProgress = buildOperationDescriptor.getTotalProgress();
        if (buildOperationCategory.isTopLevelWorkItem()) {
            logger.loggingHeader = buildOperationDescriptor.getProgressDisplayName();
        }
        return logger;
    }

    @Override
    public ProgressLogger newOperation(String loggerCategory) {
        return this.init(loggerCategory, null);
    }

    @Override
    public ProgressLogger newOperation(Class<?> loggerClass, ProgressLogger parent) {
        return this.init(loggerClass.toString(), parent);
    }

    private ProgressLogger init(String loggerCategory, @Nullable ProgressLogger parentOperation) {
        if (parentOperation != null && !(parentOperation instanceof ProgressLoggerImpl)) {
            throw new IllegalArgumentException("Unexpected parent logger.");
        }
        BuildOperationRef currentBuildOperation = this.currentBuildOperationRef.get();
        return new ProgressLoggerImpl((ProgressLoggerImpl)parentOperation, new OperationIdentifier(this.buildOperationIdFactory.nextId()), loggerCategory, this.progressListener, this.clock, false, currentBuildOperation != null ? currentBuildOperation.getId() : null, currentBuildOperation != null ? currentBuildOperation.getParentId() : null, null);
    }

    private class ProgressLoggerImpl
    implements ProgressLogger {
        private final OperationIdentifier progressOperationId;
        private final String category;
        private final ProgressListener listener;
        private final Clock clock;
        private final boolean buildOperationStart;
        @Nullable
        private final OperationIdentifier buildOperationId;
        @Nullable
        private final OperationIdentifier parentBuildOperationId;
        private final BuildOperationCategory buildOperationCategory;
        private ProgressLoggerImpl previous;
        private ProgressLoggerImpl parent;
        private String description;
        private String loggingHeader;
        private State state = State.idle;
        private int totalProgress;

        ProgressLoggerImpl(ProgressLoggerImpl parent, OperationIdentifier progressOperationId, String category, ProgressListener listener, Clock clock, @Nullable boolean buildOperationStart, @Nullable OperationIdentifier buildOperationId, @Nullable OperationIdentifier parentBuildOperationId, BuildOperationCategory buildOperationCategory) {
            this.parent = parent;
            this.progressOperationId = progressOperationId;
            this.category = category;
            this.listener = listener;
            this.clock = clock;
            this.buildOperationStart = buildOperationStart;
            this.buildOperationId = buildOperationId;
            this.parentBuildOperationId = parentBuildOperationId;
            this.buildOperationCategory = buildOperationCategory;
        }

        public String toString() {
            return this.category + " - " + this.description;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public ProgressLogger setDescription(String description) {
            this.assertCanConfigure();
            this.description = description;
            return this;
        }

        @Override
        public ProgressLogger start(String description, String status) {
            this.setDescription(description);
            this.started(status);
            return this;
        }

        @Override
        public void started() {
            this.started(null);
        }

        @Override
        public void started(String status) {
            this.started(status, this.totalProgress);
        }

        private void started(String status, int totalProgress) {
            OperationIdentifier parentProgressId;
            if (!GUtil.isTrue(this.description)) {
                throw new IllegalStateException("A description must be specified before this operation is started.");
            }
            this.assertNotStarted();
            this.state = State.started;
            this.previous = (ProgressLoggerImpl)DefaultProgressLoggerFactory.this.current.get();
            if (this.parent == null) {
                if (this.previous != null) {
                    this.parent = this.previous;
                    parentProgressId = this.parent.progressOperationId;
                } else {
                    parentProgressId = this.buildOperationStart ? this.parentBuildOperationId : this.buildOperationId;
                }
            } else {
                parentProgressId = this.parent.progressOperationId;
                this.parent.assertRunning();
            }
            DefaultProgressLoggerFactory.this.current.set(this);
            this.listener.started(new ProgressStartEvent(this.progressOperationId, parentProgressId, this.clock.getCurrentTime(), this.category, this.description, this.loggingHeader, this.ensureNotNull(status), totalProgress, this.buildOperationStart, this.buildOperationId, this.buildOperationCategory));
        }

        @Override
        public void progress(String status) {
            this.progress(status, false);
        }

        @Override
        public void progress(String status, boolean failing) {
            this.assertRunning();
            this.listener.progress(new ProgressEvent(this.progressOperationId, this.ensureNotNull(status), failing));
        }

        @Override
        public void completed() {
            this.completed(null, false);
        }

        @Override
        public void completed(String status, boolean failed) {
            this.assertRunning();
            this.state = State.completed;
            DefaultProgressLoggerFactory.this.current.set(this.previous);
            this.listener.completed(new ProgressCompleteEvent(this.progressOperationId, this.clock.getCurrentTime(), this.ensureNotNull(status), failed));
        }

        private String ensureNotNull(String status) {
            return status == null ? "" : status;
        }

        private void assertNotStarted() {
            if (this.state == State.started) {
                throw new IllegalStateException(String.format("This operation (%s) has already been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already completed.", this));
            }
        }

        private void assertRunning() {
            if (this.state == State.idle) {
                throw new IllegalStateException(String.format("This operation (%s) has not been started.", this));
            }
            if (this.state == State.completed) {
                throw new IllegalStateException(String.format("This operation (%s) has already been completed.", this));
            }
        }

        private void assertCanConfigure() {
            if (this.state != State.idle) {
                throw new IllegalStateException(String.format("Cannot configure this operation (%s) once it has started.", this));
            }
        }
    }

    private static enum State {
        idle,
        started,
        completed;

    }
}

