/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OutdatedStateManager {
    @Inject
    private OperationCanceledManager canceledManager;
    private final ThreadLocal<Boolean> cancelationAllowed = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return true;
        }
    };

    public CancelIndicator newCancelIndicator(ResourceSet rs) {
        if (rs instanceof XtextResourceSet) {
            boolean isCancelationAllowed = this.cancelationAllowed.get();
            XtextResourceSet xtextRs = (XtextResourceSet)rs;
            int current = xtextRs.getModificationStamp();
            return () -> isCancelationAllowed && (xtextRs.isOutdated() || current != xtextRs.getModificationStamp());
        }
        return CancelIndicator.NullImpl;
    }

    public void checkCanceled(ResourceSet rs) {
        if (rs instanceof XtextResourceSet && ((XtextResourceSet)rs).isOutdated() && this.cancelationAllowed.get().booleanValue()) {
            this.canceledManager.throwOperationCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, P extends Resource> R exec(IUnitOfWork<R, P> work, P param) {
        Boolean wasCancelationAllowed = this.cancelationAllowed.get();
        try {
            if (work instanceof CancelableUnitOfWork) {
                ((CancelableUnitOfWork)work).setCancelIndicator(param == null ? () -> true : this.newCancelIndicator(param.getResourceSet()));
            } else {
                this.cancelationAllowed.set(false);
            }
            Object object = work.exec(param);
            return (R)object;
        }
        catch (Throwable e) {
            Object object = Exceptions.throwUncheckedException((Throwable)e);
            return (R)object;
        }
        finally {
            this.cancelationAllowed.set(wasCancelationAllowed);
        }
    }
}

