/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.IEclipseTrace;
import org.eclipse.xtext.ui.generator.trace.ILocationInEclipseResource;
import org.eclipse.xtext.ui.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.generator.trace.OppositeFileOpenerContributor;
import org.eclipse.xtext.ui.generator.trace.StorageBasedTextEditorOpener;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;

public class TraceBasedOpenerContributor
extends OppositeFileOpenerContributor {
    @Inject
    private ITraceForStorageProvider traceForStorageProvider;

    protected StorageBasedTextEditorOpener createStorageBasedTextEditorOpener(IStorage storage, ITextRegion textRegion) {
        return new StorageBasedTextEditorOpener(storage, textRegion);
    }

    @Override
    public boolean collectGeneratedFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        IEclipseTrace trace;
        IStorage editorStorage = this.getStorage(editor);
        if (editorStorage != null && (trace = (IEclipseTrace)this.traceForStorageProvider.getTraceToTarget(editorStorage)) != null && trace.hasTraceData()) {
            this.collectOpeners(trace, this.getSelectedRegion(editor), acceptor);
            return true;
        }
        return false;
    }

    private void collectOpeners(IEclipseTrace trace, ITextRegion region, IAcceptor<FileOpener> acceptor) {
        IStorage storage;
        Iterable locations = null;
        if (region != null) {
            locations = trace.getAllAssociatedLocations(region);
        }
        if (locations == null || Iterables.isEmpty((Iterable)locations)) {
            locations = trace.getAllAssociatedLocations();
        }
        HashMap result = Maps.newHashMap();
        for (ILocationInEclipseResource iLocationInEclipseResource : locations) {
            ITextRegion old;
            storage = (IStorage)iLocationInEclipseResource.getPlatformResource();
            if (storage == null || (old = (ITextRegion)result.put(storage, iLocationInEclipseResource.getTextRegion())) == null) continue;
            ITextRegion merged = old.merge((ITextRegion)iLocationInEclipseResource.getTextRegion());
            result.put(storage, merged);
        }
        for (Map.Entry entry : result.entrySet()) {
            storage = (IStorage)entry.getKey();
            ITextRegion textRegion = (ITextRegion)entry.getValue();
            acceptor.accept((Object)this.createStorageBasedTextEditorOpener(storage, textRegion));
        }
    }

    @Override
    public boolean collectSourceFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        IEclipseTrace trace;
        IStorage editorStorage = this.getStorage(editor);
        if (editorStorage != null && (trace = (IEclipseTrace)this.traceForStorageProvider.getTraceToSource(editorStorage)) != null && trace.hasTraceData()) {
            this.collectOpeners(trace, this.getSelectedRegion(editor), acceptor);
            return true;
        }
        return false;
    }
}

