/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.io.InputStream;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class EmbeddedEditorModelAccess {
    private final SourceViewer viewer;
    private final boolean insertLineBreaks;
    private final IEditedResourceProvider resourceProvider;
    private XtextDocumentUtil xtextDocumentUtil = new XtextDocumentUtil();

    public EmbeddedEditorModelAccess(SourceViewer viewer, IEditedResourceProvider resourceProvider, boolean insertLineBreaks) {
        this.viewer = viewer;
        this.resourceProvider = resourceProvider;
        this.insertLineBreaks = insertLineBreaks;
    }

    protected void setModel(XtextDocument document, String prefix, String editablePart, String suffix) {
        if (this.insertLineBreaks) {
            String delimiter = document.getDefaultLineDelimiter();
            prefix = String.valueOf(prefix) + delimiter;
            suffix = String.valueOf(delimiter) + suffix;
        }
        String model = String.valueOf(prefix) + editablePart + suffix;
        document.set(model);
        XtextResource resource = this.createResource(model);
        document.setInput(resource);
        AnnotationModel annotationModel = new AnnotationModel();
        if (document instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            if (lock == null) {
                lock = new Object();
                ((ISynchronizable)document).setLockObject(lock);
            }
            annotationModel.setLockObject(lock);
        }
        this.viewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel, prefix.length(), editablePart.length());
    }

    protected XtextResource createResource(String content) {
        XtextResource result = this.resourceProvider.createResource();
        try {
            result.load((InputStream)new LazyStringInputStream(content, result.getEncoding()), Collections.emptyMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void updateModel(String model) {
        IDocument document = this.viewer.getDocument();
        this.viewer.setRedraw(false);
        this.viewer.getUndoManager().disconnect();
        document.set(model);
        this.viewer.resetVisibleRegion();
        this.viewer.getUndoManager().connect((ITextViewer)this.viewer);
        this.viewer.setRedraw(true);
    }

    public void updateModel(String prefix, String editablePart, String suffix) {
        IDocument document = this.viewer.getDocument();
        if (this.insertLineBreaks) {
            String delimiter = document.getLegalLineDelimiters()[0];
            if (document instanceof IDocumentExtension4) {
                delimiter = ((IDocumentExtension4)document).getDefaultLineDelimiter();
            }
            prefix = String.valueOf(prefix) + delimiter;
            suffix = String.valueOf(delimiter) + suffix;
        }
        String model = String.valueOf(prefix) + editablePart + suffix;
        this.viewer.setRedraw(false);
        this.viewer.getUndoManager().disconnect();
        document.set(model);
        this.viewer.setVisibleRegion(prefix.length(), editablePart.length());
        this.viewer.getUndoManager().connect((ITextViewer)this.viewer);
        this.viewer.setRedraw(true);
    }

    public void updateModel(String model, final String editablePartUriFragment) {
        this.updateModel(model, new IUnitOfWork<ITextRegion, XtextResource>(){

            public ITextRegion exec(XtextResource state) throws Exception {
                EObject editablePart = state.getEObject(editablePartUriFragment);
                ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)editablePart);
                if (node != null) {
                    return new TextRegion(node.getOffset(), node.getLength());
                }
                return null;
            }
        });
    }

    public void updateModel(String model, IUnitOfWork<ITextRegion, XtextResource> editablePartSelector) {
        IXtextDocument document = this.xtextDocumentUtil.getXtextDocument((ITextViewer)this.viewer);
        this.viewer.setRedraw(false);
        this.viewer.getUndoManager().disconnect();
        document.set(model);
        ITextRegion textRegion = (ITextRegion)document.readOnly(editablePartSelector);
        if (textRegion == null) {
            this.viewer.resetVisibleRegion();
        } else {
            this.viewer.setVisibleRegion(textRegion.getOffset(), textRegion.getLength());
        }
        this.viewer.getUndoManager().connect((ITextViewer)this.viewer);
        this.viewer.setRedraw(true);
    }

    public void updatePrefix(String prefix) {
        try {
            IDocument document = this.viewer.getDocument();
            IRegion visibleRegion = this.viewer.getVisibleRegion();
            String editablePart = document.get(visibleRegion.getOffset(), visibleRegion.getLength());
            int suffixOffset = visibleRegion.getOffset() + visibleRegion.getLength();
            String suffix = "";
            if (document.getLength() - suffixOffset > 0) {
                suffix = document.get(suffixOffset, document.getLength() - suffixOffset);
                if (this.insertLineBreaks) {
                    String delimiter = document.getLegalLineDelimiters()[0];
                    if (document instanceof IDocumentExtension4) {
                        delimiter = ((IDocumentExtension4)document).getDefaultLineDelimiter();
                    }
                    suffix = suffix.substring(delimiter.length());
                }
            }
            this.updateModel(prefix, editablePart, suffix);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEditablePart() {
        IDocument doc = this.viewer.getDocument();
        IRegion visible = this.viewer.getVisibleRegion();
        try {
            return doc.get(visible.getOffset(), visible.getLength());
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public String getSerializedModel() {
        return this.viewer.getDocument().get();
    }

    protected void setXtextDocumentUtil(XtextDocumentUtil xtextDocumentUtil) {
        this.xtextDocumentUtil = xtextDocumentUtil;
    }
}

