/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;

public abstract class AbstractEditorDoubleClickTextSelectionTest
extends AbstractEditorTest {
    @Inject
    private FileExtensionProvider fileExtensionProvider;

    public String c() {
        return "|";
    }

    public void assertSelectedTextAfterDoubleClicking(CharSequence charSequence, String expected) {
        IFile file = this.createFile(this.getContent(charSequence));
        try {
            XtextEditor xtextEditor = this.openEditor(file);
            xtextEditor = this.doubleClick(xtextEditor, this.getCursorPosition(charSequence));
            this.assertSelectedText((AbstractTextEditor)xtextEditor, expected);
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening editor associated with the file " + file.getName());
        }
    }

    protected void assertSelectedText(AbstractTextEditor textEditor, CharSequence expectedSelectedText) {
        ISelection selection = textEditor.getSelectionProvider().getSelection();
        String actualSelectedText = ((ITextSelection)selection).getText();
        AbstractEditorDoubleClickTextSelectionTest.assertEquals((Object)expectedSelectedText, (Object)actualSelectedText);
    }

    protected String getContent(CharSequence text) {
        return text.toString().replace(this.c(), "");
    }

    protected IFile createFile(String content) {
        try {
            return IResourcesSetupUtil.createFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
        }
        catch (InterruptedException | InvocationTargetException | CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getProjectName() {
        return "Test";
    }

    protected String getFileName() {
        return "Foo";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }

    protected int getCursorPosition(CharSequence text) {
        int cursorPosition = text.toString().indexOf(this.c());
        if (cursorPosition == -1) {
            String message = "The input text\n%s\nmust contain the '%s' special symbol indicating the current cursor position!\n";
            AbstractEditorDoubleClickTextSelectionTest.fail((String)String.format(message, text, this.c()));
        }
        return cursorPosition;
    }

    protected XtextEditor doubleClick(XtextEditor xtextEditor, int cursorPosition) {
        ISourceViewer viewer = xtextEditor.getInternalSourceViewer();
        viewer.setSelectedRange(cursorPosition, 0);
        Event event = new Event();
        event.button = 1;
        viewer.getTextWidget().notifyListeners(3, event);
        return xtextEditor;
    }
}

