/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.editor.contentassist.antlr;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;

public class EntryPointFinder {
    public ICompositeNode findEntryPoint(IParseResult parseResult, int offset) {
        EObject grammarElement;
        ICompositeNode rootNode = parseResult.getRootNode();
        if (rootNode.getTotalLength() == offset) {
            return null;
        }
        ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)offset);
        ICompositeNode parent = leafNode.getParent();
        ICompositeNode result = this.findEntryPoint(parent, offset);
        if (result != null && (grammarElement = result.getGrammarElement()) instanceof AbstractElement) {
            return result;
        }
        return null;
    }

    protected ICompositeNode findEntryPoint(ICompositeNode node, int offset) {
        ICompositeNode result = node;
        result = this.getApplicableNode(result);
        while (result != null) {
            int remainingLookAhead = result.getLookAhead();
            if (remainingLookAhead != 0) {
                ILeafNode leaf;
                Iterator leafNodes = result.getLeafNodes().iterator();
                while (leafNodes.hasNext() && remainingLookAhead > 0 && (leaf = (ILeafNode)leafNodes.next()).getTotalOffset() < offset) {
                    if (leaf.isHidden()) continue;
                    if (remainingLookAhead > 0) {
                        --remainingLookAhead;
                    }
                    if (remainingLookAhead != 0) continue;
                    if (this.shouldUseParent(result, offset, leaf)) {
                        ICompositeNode parent = result.getParent();
                        return parent;
                    }
                    return result;
                }
            }
            result = this.getApplicableNode(result.getParent());
        }
        return result;
    }

    protected boolean shouldUseParent(ICompositeNode result, int offset, ILeafNode leaf) {
        if (leaf.getTotalEndOffset() == offset) {
            return true;
        }
        if (result.getGrammarElement() instanceof RuleCall) {
            RuleCall rc = (RuleCall)result.getGrammarElement();
            if (!rc.getArguments().isEmpty()) {
                return true;
            }
            Assignment assignment = GrammarUtil.containingAssignment((EObject)rc);
            if (assignment != null && (GrammarUtil.isMultipleCardinality((AbstractElement)assignment) || assignment.eContainer() instanceof AbstractElement && GrammarUtil.isMultipleCardinality((AbstractElement)((AbstractElement)assignment.eContainer())))) {
                return true;
            }
        }
        return false;
    }

    protected ICompositeNode normalizeToParent(ICompositeNode result) {
        if (result == null) {
            return result;
        }
        ICompositeNode parent = result.getParent();
        while (parent != null && parent.getFirstChild().equals(result) && parent.getLookAhead() == result.getLookAhead()) {
            result = parent;
            parent = result.getParent();
        }
        return result;
    }

    protected ICompositeNode getApplicableNode(ICompositeNode result) {
        while (result != null && result.getGrammarElement() == null) {
            result = result.getParent();
        }
        return this.normalizeToParent(result);
    }
}

