/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.builder.trace.DebugLocationData;
import org.eclipse.xtext.builder.trace.DebugTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;

public class DebugTraceBasedRegion
extends AbstractTraceRegion {
    private final DebugTraceRegion delegate;

    protected DebugTraceBasedRegion(AbstractTraceRegion parent, DebugTraceRegion delegate) {
        super(parent);
        this.delegate = delegate;
        for (DebugTraceRegion child : delegate.getNestedRegions()) {
            new DebugTraceBasedRegion(this, child);
        }
    }

    private LocationData convert(DebugLocationData data) {
        SourceRelativeURI uri = data.getPath() != null ? new SourceRelativeURI(data.getPath()) : null;
        return new LocationData(data.getOffset(), data.getLength(), data.getLineNumber(), data.getEndLineNumber(), uri);
    }

    public List<ILocationData> getAssociatedLocations() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.delegate.getAssociations().size());
        for (DebugLocationData data : this.delegate.getAssociations()) {
            result.add(this.convert(data));
        }
        return result;
    }

    public SourceRelativeURI getAssociatedSrcRelativePath() {
        SourceRelativeURI path = super.getAssociatedSrcRelativePath();
        if (path != null) {
            return path;
        }
        return this.getAssociatedSrcRelativePath(this.delegate);
    }

    protected SourceRelativeURI getAssociatedSrcRelativePath(DebugTraceRegion region) {
        for (DebugLocationData associated : region.getAssociations()) {
            URI uri = associated.getPath();
            if (uri == null) continue;
            return new SourceRelativeURI(uri);
        }
        EObject container = region.eContainer();
        if (container instanceof DebugTraceRegion) {
            return this.getAssociatedSrcRelativePath((DebugTraceRegion)container);
        }
        return null;
    }

    public int getMyEndLineNumber() {
        return this.delegate.getMyEndLineNumber();
    }

    public int getMyLength() {
        return this.delegate.getMyLength();
    }

    public int getMyLineNumber() {
        return this.delegate.getMyLineNumber();
    }

    public int getMyOffset() {
        return this.delegate.getMyOffset();
    }

    public boolean isUseForDebugging() {
        return this.delegate.isUseForDebugging();
    }
}

