/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.navigation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.internal.xpand2.ast.AbstractDefinition;
import org.eclipse.internal.xpand2.ast.ExtensionImportDeclaration;
import org.eclipse.internal.xpand2.ast.Template;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Literal;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.type.baseimpl.PolymorphicResolver;
import org.eclipse.internal.xtend.type.baseimpl.types.CollectionTypeImpl;
import org.eclipse.internal.xtend.xtend.XtendFile;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.Check;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.ast.ExtensionImportStatement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.expression.VetoableCallback;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.core.search.XtendXpandSearchEngine;
import org.eclipse.xtend.shared.ui.editor.navigation.ContextComputer;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlink;
import org.eclipse.xtend.shared.ui.editor.navigation.GenericHyperlinkDetector;
import org.eclipse.xtend.shared.ui.editor.navigation.WordDetector;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHyperlinkDetector
implements IHyperlinkDetector {
    protected final IEditorPart editor;
    protected IXtendXpandResource _xxresource = null;

    public AbstractHyperlinkDetector(IEditorPart editor) {
        this.editor = editor;
    }

    protected List<GenericHyperlink> computeMatchesAndHyperlinks(IRegion hyperlinkRegion, String hyperlinkedWord, IXtendXpandProject project) {
        int compare;
        IXtendXpandResource resource = Activator.getExtXptModelManager().findExtXptResource((IStorage)this.getFile());
        List<GenericHyperlink> links = this.createHyperlinkToImportedExtensions(resource, hyperlinkRegion, hyperlinkedWord);
        if (!links.isEmpty()) {
            return links;
        }
        OperationCall expression = null;
        expression = resource.getExtXptResource() instanceof XtendFile ? XtendXpandSearchEngine.findExpressionInExtensionFile(hyperlinkRegion, (ExtensionFile)resource.getExtXptResource(), hyperlinkedWord) : XtendXpandSearchEngine.findExpressionInTemplate(hyperlinkedWord, (Template)resource.getExtXptResource());
        if (expression == null) {
            return this.useGenericHyplerlinkDetector(hyperlinkRegion, hyperlinkedWord, project);
        }
        ArrayList<Type> evaluatedParams = new ArrayList<Type>();
        ContextComputer helper = this.computeContext(resource, (Expression)expression);
        if (helper == null || helper.getContext() == null) {
            return this.useGenericHyplerlinkDetector(hyperlinkRegion, hyperlinkedWord, project);
        }
        ExecutionContext filledContext = helper.getContext();
        if (expression.getParams().length > 0) {
            Expression[] expressionArray = expression.getParams();
            int n = expressionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Expression ex = expressionArray[n2];
                if (ex instanceof Literal) {
                    Type type = filledContext.getTypeForName(ex.getClass().getSimpleName().replaceFirst("Literal", ""));
                    evaluatedParams.add(type);
                } else {
                    evaluatedParams.add(ex.analyze(filledContext, new HashSet()));
                }
                ++n2;
            }
        }
        Type targetType = null;
        if (helper.expressionResult != null && helper.expressionResult instanceof Type && expression.getTarget() != null) {
            targetType = (Type)helper.expressionResult;
        } else {
            Variable var = filledContext.getVariable("this");
            if (var != null) {
                targetType = (Type)var.getValue();
            }
        }
        ArrayList<Extension> candidates = new ArrayList<Extension>();
        for (Extension candidate : filledContext.getAllExtensions()) {
            if (!hyperlinkedWord.equals(candidate.getName())) continue;
            candidates.add(candidate);
        }
        ArrayList<Extension> extmatches = new ArrayList<Extension>(candidates.size());
        for (Extension ext : candidates) {
            compare = PolymorphicResolver.typesComparator.compare(ext.getParameterTypes(), evaluatedParams);
            if (compare == 0) {
                extmatches.add(0, ext);
                continue;
            }
            if (compare != 1) continue;
            extmatches.add(ext);
        }
        evaluatedParams.add(0, targetType);
        for (Extension ext : candidates) {
            compare = PolymorphicResolver.typesComparator.compare(ext.getParameterTypes(), evaluatedParams);
            if (compare == 0) {
                extmatches.add(0, ext);
                continue;
            }
            if (compare != 1) continue;
            extmatches.add(ext);
        }
        if (targetType instanceof CollectionTypeImpl) {
            evaluatedParams.remove(0);
            evaluatedParams.add(((CollectionTypeImpl)targetType).getInnerType());
            for (Extension ext : candidates) {
                compare = PolymorphicResolver.typesComparator.compare(ext.getParameterTypes(), evaluatedParams);
                if (compare == 0) {
                    extmatches.add(0, ext);
                    continue;
                }
                if (compare != 1) continue;
                extmatches.add(ext);
            }
        }
        return this.createHyperlink(hyperlinkRegion, hyperlinkedWord, links, extmatches);
    }

    protected List<GenericHyperlink> useGenericHyplerlinkDetector(IRegion hyperlinkRegion, String hyperlinkedWord, IXtendXpandProject project) {
        GenericHyperlinkDetector genericHyperlinkDetector = new GenericHyperlinkDetector(this.editor);
        return genericHyperlinkDetector.computeMatchesAndHyperlinks(hyperlinkRegion, hyperlinkedWord, project);
    }

    protected SyntaxElement findOwningElement(IXtendXpandResource file, Expression expression) {
        int start = expression.getStart();
        if (file.getExtXptResource() == null) {
            return null;
        }
        if (file.getExtXptResource() instanceof ExtensionFile) {
            ExtensionFile extensionFile = (ExtensionFile)file.getExtXptResource();
            for (Extension ext : extensionFile.getExtensions()) {
                if (ext.getStart() > start || ext.getEnd() < start) continue;
                return (SyntaxElement)ext;
            }
            for (Extension ext : extensionFile.getChecks()) {
                if (ext.getStart() > start || ext.getEnd() < start) continue;
                return ext;
            }
            for (Extension ext : extensionFile.getArounds()) {
                if (ext.getStart() > start || ext.getEnd() < start) continue;
                return ext;
            }
        }
        if (file.getExtXptResource() instanceof Template) {
            Template template = (Template)file.getExtXptResource();
            AbstractDefinition[] abstractDefinitionArray = template.getAllDefinitions();
            int n = abstractDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Extension ext;
                ext = abstractDefinitionArray[n2];
                if (ext.getStart() <= start && ext.getEnd() >= start) {
                    return ext;
                }
                ++n2;
            }
        }
        return null;
    }

    protected ContextComputer computeContext(IXtendXpandResource resource, Expression expression) {
        SyntaxElement element = this.findOwningElement(resource, expression);
        IResource file = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        IProject p = file.getProject();
        ExecutionContext c = Activator.getExecutionContext(JavaCore.create((IProject)p));
        ExecutionContextImpl context = (ExecutionContextImpl)c.cloneWithResource((Resource)resource);
        ContextComputer callback = new ContextComputer(expression);
        context.setVetoableCallBack((VetoableCallback)callback);
        if (element instanceof Extension) {
            ((Extension)element).analyze((ExecutionContext)context, new HashSet());
        }
        if (element instanceof AbstractDefinition) {
            ((AbstractDefinition)element).analyze((XpandExecutionContext)context, new HashSet());
        }
        if (element instanceof Check) {
            ((Check)element).analyze((ExecutionContext)context, new HashSet());
        }
        if (element instanceof Around) {
            ((Around)element).analyze((ExecutionContext)context, new HashSet());
        }
        return callback;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        List<GenericHyperlink> links;
        if (region == null || textViewer == null) {
            return null;
        }
        IRegion hyperlinkRegion = this.getHyperlinkRegion(textViewer, region.getOffset());
        if (hyperlinkRegion == null) {
            return null;
        }
        String hyperlinkedWord = textViewer.getDocument().get().substring(hyperlinkRegion.getOffset(), hyperlinkRegion.getOffset() + hyperlinkRegion.getLength());
        IXtendXpandProject project = this.getXtendXpandProject();
        if (project != null && !(links = this.computeMatchesAndHyperlinks(hyperlinkRegion, hyperlinkedWord, project)).isEmpty()) {
            if (canShowMultipleHyperlinks) {
                return links.toArray(new IHyperlink[links.size()]);
            }
            return new IHyperlink[]{links.get(0)};
        }
        return null;
    }

    protected IWorkbenchPage getWorkbenchPage() {
        return this.editor.getSite().getWorkbenchWindow().getActivePage();
    }

    protected IXtendXpandProject getXtendXpandProject() {
        IFile file = this.getFile();
        if (file == null) {
            return null;
        }
        return Activator.getExtXptModelManager().findProject((IResource)file);
    }

    protected IFile getFile() {
        return (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
    }

    protected IRegion getHyperlinkRegion(ITextViewer textViewer, int offset) {
        String currDoc = textViewer.getDocument().get();
        if (offset == currDoc.length()) {
            return null;
        }
        int start = offset;
        while (start > -1 && WordDetector.isWordPart(currDoc.charAt(start))) {
            --start;
        }
        ++start;
        int end = offset;
        while (end < currDoc.length() && WordDetector.isWordPart(currDoc.charAt(end))) {
            ++end;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < start) {
            end = start;
        }
        return new Region(start, end - start);
    }

    protected String computeHyperlinkLabel(String name, String typeName, List<DeclaredParameter> params, IXtendXpandResource xxresource) {
        StringBuffer label = new StringBuffer(name);
        if (!params.isEmpty()) {
            label.append("(");
            Iterator<DeclaredParameter> iter = params.iterator();
            while (iter.hasNext()) {
                DeclaredParameter param = iter.next();
                label.append(param.getType().toString());
                label.append(" " + param.getName().toString());
                if (!iter.hasNext()) continue;
                label.append(", ");
            }
            label.append(")");
        }
        if (typeName != null) {
            label.append(" : " + typeName);
        }
        if (!xxresource.getUnderlyingStorage().equals(this.getFile())) {
            label.append(" - " + xxresource.getUnderlyingStorage().getName().toString().replace("." + xxresource.getFileExtension(), ""));
        }
        return label.toString();
    }

    protected IXtendXpandResource getXXResourceByName(String fqName, String extension) {
        if (this._xxresource != null && this._xxresource.getFileExtension().equals(extension) && this._xxresource.getFullyQualifiedName().equals(fqName)) {
            return this._xxresource;
        }
        this._xxresource = this.getXtendXpandProject().findExtXptResource(fqName, extension);
        return this._xxresource;
    }

    private List<GenericHyperlink> createHyperlink(IRegion hyperlinkRegion, String hyperlinkedWord, List<GenericHyperlink> links, List<Extension> extmatches) {
        for (Extension ext : extmatches) {
            SearchMatch match = new SearchMatch(ext.getStart(), ext.getEnd() - ext.getStart() + 1, this.getXXResourceByName(ext.getFileName().replaceAll("::", "/"), "ext").getUnderlyingStorage());
            GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), match, hyperlinkRegion, this.computeHyperlinkLabel(hyperlinkedWord, ext.getReturnTypeIdentifier() == null ? null : ext.getReturnTypeIdentifier().toString(), ext.getFormalParameters(), this.getXXResourceByName(ext.getFileName().replaceAll("::", "/"), "ext")));
            links.add(genericHyperlink);
        }
        return links;
    }

    protected List<GenericHyperlink> createHyperlinkToImportedExtensions(IXtendXpandResource resource, IRegion region, String hyperlinkedName) {
        ArrayList<GenericHyperlink> links = new ArrayList<GenericHyperlink>();
        IXtendXpandResource xxresource = null;
        if (resource.getExtXptResource() instanceof ExtensionFile) {
            ExtensionFile extensionFile = (ExtensionFile)resource.getExtXptResource();
            for (ExtensionImportStatement importStatement : extensionFile.getExtImports()) {
                if (!importStatement.getImportedId().toString().contains(hyperlinkedName) || importStatement.getStart() > region.getOffset() || importStatement.getEnd() < region.getOffset() + region.getLength() || (xxresource = this.getXtendXpandProject().findExtXptResource(importStatement.getImportedId().toString(), "ext")) == null) continue;
                GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), new SearchMatch(0, 0, xxresource.getUnderlyingStorage()), (IRegion)new Region(importStatement.getImportedId().getStart(), importStatement.getImportedId().getEnd() - importStatement.getImportedId().getStart() + 1), importStatement.getImportedId().toString());
                links.add(genericHyperlink);
            }
        }
        if (resource.getExtXptResource() instanceof Template) {
            Template template = (Template)resource.getExtXptResource();
            ExtensionImportDeclaration[] extensionImportDeclarationArray = template.getExtensions();
            int n = extensionImportDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExtensionImportStatement importStatement;
                importStatement = extensionImportDeclarationArray[n2];
                if (importStatement.getImportString().toString().contains(hyperlinkedName) && importStatement.getStart() <= region.getOffset() && importStatement.getEnd() >= region.getOffset() + region.getLength() && (xxresource = this.getXtendXpandProject().findExtXptResource(importStatement.getImportString().toString(), "ext")) != null) {
                    GenericHyperlink genericHyperlink = new GenericHyperlink(this.getWorkbenchPage(), new SearchMatch(0, 0, xxresource.getUnderlyingStorage()), (IRegion)new Region(importStatement.getImportString().getStart(), importStatement.getImportString().getEnd() - importStatement.getImportString().getStart() + 1), importStatement.getImportString().toString());
                    links.add(genericHyperlink);
                }
                ++n2;
            }
        }
        return links;
    }
}

