/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro.declaration;

import java.io.InputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.core.macro.declaration.IResourceChangeRegistry;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.macro.file.MutableFileSystemSupport;
import org.eclipse.xtend.lib.macro.file.Path;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class ChangeListenerAddingFileSystemSupport
implements MutableFileSystemSupport {
    private final URI resourceURI;
    private final MutableFileSystemSupport delegate;
    private final IResourceChangeRegistry resourceChangeRegistry;

    public void delete(Path path) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.delete(path);
    }

    public void mkdir(Path path) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.mkdir(path);
    }

    public void setContents(Path path, CharSequence contents) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.setContents(path, contents);
    }

    public void setContentsAsStream(Path path, InputStream source) {
        this.resourceChangeRegistry.registerCreateOrModify(path.toString(), this.getURI());
        this.delegate.setContentsAsStream(path, source);
    }

    public boolean exists(Path path) {
        this.resourceChangeRegistry.registerExists(path.toString(), this.getURI());
        return this.delegate.exists(path);
    }

    private URI getURI() {
        return this.resourceURI;
    }

    public String getCharset(Path path) {
        this.resourceChangeRegistry.registerGetCharset(path.toString(), this.getURI());
        return this.delegate.getCharset(path);
    }

    public Iterable<? extends Path> getChildren(Path path) {
        this.resourceChangeRegistry.registerGetChildren(path.toString(), this.getURI());
        return this.delegate.getChildren(path);
    }

    public CharSequence getContents(Path path) {
        this.resourceChangeRegistry.registerGetContents(path.toString(), this.getURI());
        return this.delegate.getContents(path);
    }

    public InputStream getContentsAsStream(Path path) {
        this.resourceChangeRegistry.registerGetContents(path.toString(), this.getURI());
        return this.delegate.getContentsAsStream(path);
    }

    public long getLastModification(Path path) {
        this.resourceChangeRegistry.registerGetContents(path.toString(), this.getURI());
        return this.delegate.getLastModification(path);
    }

    public boolean isFile(Path path) {
        this.resourceChangeRegistry.registerExists(path.toString(), this.getURI());
        return this.delegate.isFile(path);
    }

    public boolean isFolder(Path path) {
        this.resourceChangeRegistry.registerExists(path.toString(), this.getURI());
        return this.delegate.isFolder(path);
    }

    public java.net.URI toURI(Path path) {
        return this.delegate.toURI(path);
    }

    public ChangeListenerAddingFileSystemSupport(URI resourceURI, MutableFileSystemSupport delegate, IResourceChangeRegistry resourceChangeRegistry) {
        this.resourceURI = resourceURI;
        this.delegate = delegate;
        this.resourceChangeRegistry = resourceChangeRegistry;
    }

    @Pure
    public URI getResourceURI() {
        return this.resourceURI;
    }

    @Pure
    public MutableFileSystemSupport getDelegate() {
        return this.delegate;
    }

    @Pure
    public IResourceChangeRegistry getResourceChangeRegistry() {
        return this.resourceChangeRegistry;
    }
}

