/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextViewerConfiguration;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xsl.ui.internal.Messages;
import org.eclipse.wst.xsl.ui.internal.StructuredTextViewerConfigurationXSL;
import org.eclipse.wst.xsl.ui.internal.XSLUIPlugin;
import org.eclipse.wst.xsl.ui.internal.wizards.TemplateContentProvider;
import org.eclipse.wst.xsl.ui.internal.wizards.TemplateLabelProvider;

public class NewXSLFileTemplatesWizardPage
extends WizardPage {
    private static final String XSL_UI_TEMPLATE_PREFERENCE_PAGE = "org.eclipse.wst.xsl.ui.template.preferencePage";
    private static final String NEW_STYLESHEET_TEMPLATES_WIZARD_PAGE = "NewStylesheetTemplatesWizardPage";
    private String fLastSelectedTemplateName;
    private SourceViewer fPatternViewer;
    private TableViewer fTableViewer;
    private TemplateStore fTemplateStore;
    private Button fUseTemplateButton;

    public NewXSLFileTemplatesWizardPage() {
        super(NEW_STYLESHEET_TEMPLATES_WIZARD_PAGE, Messages.NewXSLSelectTemplate, null);
        this.setDescription(Messages.NewXSLTemplateDescription);
    }

    private void configureTableResizing(final Composite parent, final Table table, final TableColumn column1, final TableColumn column2) {
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = parent.getClientArea();
                Point preferredSize = table.computeSize(-1, -1);
                int width = area.width - 2 * table.getBorderWidth();
                if (preferredSize.y > area.height) {
                    Point vBarSize = table.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = table.getSize();
                if (oldSize.x > width) {
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                    table.setSize(width, area.height);
                } else {
                    table.setSize(width, area.height);
                    column1.setWidth(width / 2);
                    column2.setWidth(width / 2);
                }
            }
        });
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.fUseTemplateButton = new Button(parent, 32);
        this.fUseTemplateButton.setText(Messages.NewXSLUseTemplateButtonText);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        this.fUseTemplateButton.setLayoutData((Object)data);
        this.fUseTemplateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewXSLFileTemplatesWizardPage.this.enableTemplates();
            }
        });
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        innerParent.setLayoutData((Object)gd);
        Link link = new Link(innerParent, 0);
        link.setText(Messages.NewXSLLinkPreferencePage);
        data = new GridData(4, 4, true, false, 2, 1);
        link.setLayoutData((Object)data);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewXSLFileTemplatesWizardPage.this.linkClicked();
            }
        });
        Table table = new Table(innerParent, 67584);
        data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(2);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.NewXSLColumnTemplateName);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.NewXSLColumnTemplateDescription);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new TemplateContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof Template && object2 instanceof Template) {
                    Template left = (Template)object1;
                    Template right = (Template)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NewXSLFileTemplatesWizardPage.this.updateViewerInput();
            }
        });
        this.fPatternViewer = this.doCreateViewer(parent);
        this.fTemplateStore = XSLUIPlugin.getDefault().getTemplateStore();
        this.fTableViewer.setInput((Object)this.fTemplateStore);
        this.configureTableResizing(innerParent, table, column1, column2);
        this.loadLastSavedPreferences();
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    private SourceViewer createViewer(Composite parent) {
        StructuredTextViewerConfiguration sourceViewerConfiguration = new StructuredTextViewerConfiguration(){
            StructuredTextViewerConfiguration baseConfiguration = new StructuredTextViewerConfigurationXSL();

            public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
                return this.baseConfiguration.getConfiguredContentTypes(sourceViewer);
            }

            public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
                return this.baseConfiguration.getLineStyleProviders(sourceViewer, partitionType);
            }
        };
        StructuredTextViewer viewer = new StructuredTextViewer(parent, null, null, false, 2816);
        viewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
        IStructuredModel scratchModel = StructuredModelManager.getModelManager().createUnManagedStructuredModelFor(ContentTypeIdForXML.ContentTypeID_XML);
        IStructuredDocument document = scratchModel.getStructuredDocument();
        viewer.configure((SourceViewerConfiguration)sourceViewerConfiguration);
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private SourceViewer doCreateViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.NewXSLTemplatePreviewTitle);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        data = new GridData(1808);
        data.horizontalSpan = 2;
        data.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    void enableTemplates() {
        boolean enabled = this.fUseTemplateButton.getSelection();
        if (enabled) {
            this.setSelectedTemplate(this.fLastSelectedTemplateName);
        } else {
            Template template = this.getSelectedTemplate();
            this.fLastSelectedTemplateName = template != null ? template.getName() : "";
            this.fTableViewer.setSelection(null);
        }
        this.fTableViewer.getControl().setEnabled(enabled);
        this.fPatternViewer.getControl().setEnabled(enabled);
    }

    private Template getSelectedTemplate() {
        Template template = null;
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            template = (Template)selection.getFirstElement();
        }
        return template;
    }

    String getTemplateString(int[] offset) {
        String templateString = null;
        offset[0] = 0;
        Template template = this.getSelectedTemplate();
        if (template != null) {
            TemplateContextType contextType = XSLUIPlugin.getDefault().getTemplateContextRegistry().getContextType("xsl_new");
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                templateString = buffer.getString();
                TemplateVariable[] templateVariableArray = buffer.getVariables();
                int n = templateVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateVariable t = templateVariableArray[n2];
                    if (t.getName().equals("cursor") && t.getOffsets().length > 0) {
                        offset[0] = t.getOffsets()[0];
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                XSLUIPlugin.log(e);
            }
        }
        return templateString;
    }

    void linkClicked() {
        String pageId = XSL_UI_TEMPLATE_PREFERENCE_PAGE;
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.open();
        this.fTableViewer.refresh();
    }

    private void loadLastSavedPreferences() {
        String templateName = XSLUIPlugin.getDefault().getPreferenceStore().getString("NEW_FILE_TEMPLATE_NAME");
        if (templateName == null || templateName.length() == 0) {
            this.fLastSelectedTemplateName = "";
            this.fUseTemplateButton.setSelection(false);
        } else {
            this.fLastSelectedTemplateName = templateName;
            this.fUseTemplateButton.setSelection(true);
        }
        this.enableTemplates();
    }

    void saveLastSavedPreferences() {
        String templateName = "";
        Template template = this.getSelectedTemplate();
        if (template != null) {
            templateName = template.getName();
        }
        XSLUIPlugin.getDefault().getPreferenceStore().setValue("NEW_FILE_TEMPLATE_NAME", templateName);
        XSLUIPlugin.getDefault().savePluginPreferences();
    }

    private void setSelectedTemplate(String templateName) {
        Object template = null;
        if (templateName != null && templateName.length() > 0) {
            template = this.fTemplateStore.findTemplate(templateName, "xsl_new");
        }
        if (template == null) {
            template = this.fTableViewer.getElementAt(0);
        }
        if (template != null) {
            StructuredSelection selection = new StructuredSelection(template);
            this.fTableViewer.setSelection((ISelection)selection, true);
        }
    }

    void updateViewerInput() {
        Template template = this.getSelectedTemplate();
        if (template != null) {
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }
}

