/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.wizard;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class RefactorGroupActionDelegate
implements IObjectActionDelegate,
IEditorActionDelegate,
IMenuCreator {
    protected ISelection fSelection;
    private IAction fDelegateAction;
    private boolean fFillMenu = true;
    protected IWorkbenchPart workbenchPart;
    protected ResourceSet resourceSet = new ResourceSetImpl();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                if (RefactorGroupActionDelegate.this.fFillMenu) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    RefactorGroupActionDelegate.this.fillMenu(m);
                    RefactorGroupActionDelegate.this.fFillMenu = false;
                }
            }
        });
        return menu;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fDelegateAction = action;
        this.updateWith(selection);
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.workbenchPart = targetEditor;
        this.fDelegateAction = action;
        if (targetEditor != null && targetEditor.getEditorSite() != null && targetEditor.getEditorSite().getSelectionProvider() != null) {
            this.updateWith(targetEditor.getEditorSite().getSelectionProvider().getSelection());
        }
    }

    public void updateWith(ISelection selection) {
        this.fSelection = selection;
        if (this.fDelegateAction != null) {
            boolean enable = false;
            if (selection != null) {
                if (selection instanceof ITextSelection) {
                    enable = true;
                } else if (selection instanceof IStructuredSelection) {
                    enable = !selection.isEmpty();
                }
            }
            this.fDelegateAction.setEnabled(enable);
            this.fFillMenu = true;
            this.fDelegateAction.setMenuCreator((IMenuCreator)this);
        }
    }

    protected abstract void fillMenu(Menu var1);
}

