/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SortingSearchRequestor
extends SearchRequestor {
    public static String NONAMESPACE = "nonamespace";
    private Map fFound = new HashMap();

    public Map getResults() {
        return this.fFound;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        if (match != null && match.getObject() instanceof Node) {
            Node node = (Node)match.getObject();
            Node domElement = null;
            switch (node.getNodeType()) {
                case 2: {
                    domElement = ((Attr)node).getOwnerElement();
                    break;
                }
                case 1: {
                    domElement = (Element)node;
                    break;
                }
            }
            String namespace = domElement.getNamespaceURI();
            if (namespace == null || namespace.equals("")) {
                namespace = NONAMESPACE;
            }
            List matches = this.getMatches(namespace);
            matches.add(match);
        }
    }

    private List getMatches(String namespace) {
        Object matches = this.fFound.get(namespace);
        if (!(matches instanceof List)) {
            matches = new ArrayList();
            this.fFound.put(namespace, matches);
        }
        return (List)matches;
    }
}

