/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.xsd.ui.internal.adt.editor.IADTEditorInput;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.xsd.XSDSchema;

public class XSDFileEditorInput
extends FileEditorInput
implements IADTEditorInput {
    private IFile file;
    private XSDSchema schema;
    private String editorName;

    public XSDFileEditorInput(IFile file, XSDSchema schema) {
        super(file);
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
        this.schema = schema;
        this.editorName = file.getName();
    }

    public IFile getFile() {
        return this.file;
    }

    public XSDSchema getSchema() {
        return this.schema;
    }

    public void setEditorName(String name) {
        this.editorName = name;
    }

    public String getName() {
        if (this.editorName != null) {
            return this.editorName;
        }
        return super.getName();
    }

    public String getToolTipText() {
        if (this.schema != null) {
            String ns = this.schema.getTargetNamespace();
            if (ns != null && ns.length() > 0) {
                return String.valueOf(Messages._UI_LABEL_TARGET_NAMESPACE) + ns;
            }
            return Messages._UI_LABEL_NO_NAMESPACE;
        }
        return super.getToolTipText();
    }
}

