/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateMaxOccursCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateMinOccursCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.RefactoringSection;
import org.eclipse.wst.xsd.ui.internal.common.util.Messages;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.w3c.dom.Element;

public class MultiplicitySection
extends RefactoringSection {
    protected CCombo minCombo;
    protected CCombo maxCombo;

    protected void createContents(Composite parent) {
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.minCombo) {
            this.updateMinAttribute();
        } else if (event.widget == this.maxCombo) {
            this.updateMaxAttribute();
        }
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.minCombo) {
            this.updateMinAttribute();
        } else if (e.widget == this.maxCombo) {
            this.updateMaxAttribute();
        }
        super.doWidgetSelected(e);
    }

    protected void updateMaxAttribute() {
        this.setErrorMessage(null);
        XSDParticle particle = null;
        if (this.input instanceof XSDParticleContent) {
            particle = this.getAssociatedParticle((XSDParticleContent)this.input);
        }
        if (particle != null) {
            String newValue = this.maxCombo.getText().trim();
            if (newValue.length() == 0) {
                particle.unsetMaxOccurs();
                return;
            }
            try {
                int newMax = 1;
                if (newValue.equals("unbounded") || newValue.equals("*")) {
                    newMax = -1;
                } else if (newValue.length() > 0) {
                    newMax = Integer.parseInt(newValue);
                }
                this.setListenerEnabled(false);
                UpdateMaxOccursCommand command = new UpdateMaxOccursCommand(Messages._UI_ACTION_CHANGE_MAXIMUM_OCCURRENCE, particle, newMax);
                this.getCommandStack().execute((Command)command);
                this.setListenerEnabled(true);
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage(Messages._UI_ERROR_INVALID_VALUE_FOR_MAXIMUM_OCCURRENCE);
            }
        }
    }

    protected void updateMinAttribute() {
        this.setErrorMessage(null);
        XSDParticle particle = null;
        if (this.input instanceof XSDParticleContent) {
            particle = this.getAssociatedParticle((XSDParticleContent)this.input);
        }
        if (particle != null) {
            String newValue = this.minCombo.getText();
            if (newValue.length() == 0) {
                particle.unsetMinOccurs();
            }
            try {
                int newMin = 1;
                newMin = newValue.equals("unbounded") || newValue.equals("*") ? -1 : Integer.parseInt(newValue);
                UpdateMinOccursCommand command = new UpdateMinOccursCommand(Messages._UI_ACTION_CHANGE_MINIMUM_OCCURRENCE, (XSDComponent)particle, newMin);
                this.getCommandStack().execute((Command)command);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void refreshMinMax() {
        Element element;
        XSDParticle particle;
        boolean refreshMinText = true;
        boolean refreshMaxText = true;
        if (this.minCombo.isFocusControl()) {
            refreshMinText = false;
        }
        if (this.maxCombo.isFocusControl()) {
            refreshMaxText = false;
        }
        if (refreshMinText) {
            this.minCombo.setText("");
        }
        if (refreshMaxText) {
            this.maxCombo.setText("");
        }
        if (this.input != null && this.input instanceof XSDParticleContent && (particle = this.getAssociatedParticle((XSDParticleContent)this.input)) != null && (element = particle.getElement()) != null) {
            if (element.hasAttribute("minOccurs") && refreshMinText) {
                String min = element.getAttribute("minOccurs");
                this.minCombo.setText(min);
            }
            if (element.hasAttribute("maxOccurs") && refreshMaxText) {
                String max = element.getAttribute("maxOccurs");
                this.maxCombo.setText(max);
            }
        }
    }

    protected XSDParticle getAssociatedParticle(XSDParticleContent particleContent) {
        XSDConcreteComponent xsdComp = particleContent.getContainer();
        if (xsdComp instanceof XSDParticle) {
            return (XSDParticle)xsdComp;
        }
        return null;
    }

    public void dispose() {
        if (this.minCombo != null && !this.minCombo.isDisposed()) {
            this.removeListeners((Control)this.minCombo);
        }
        if (this.maxCombo != null && !this.maxCombo.isDisposed()) {
            this.removeListeners((Control)this.maxCombo);
        }
        super.dispose();
    }
}

