/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.actions;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.design.layouts.FillLayout;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class CaptureScreenAction
extends Action {
    private static String LAST_SCREEN_CAPTURE_PATH = System.getProperty("user.home");
    private static String LAST_SCREEN_CAPTURE_FILE_NAME = Messages._UI_ACTION_CAPTURE_SCREEN_DEFAULT_FILE_NAME;
    private static String LAST_SCREEN_CAPTURE_FILE_EXTENSION = ".jpg";
    static /* synthetic */ Class class$0;

    public CaptureScreenAction() {
        this.setText(Messages._UI_CAPTURE_SCREEN_ACTION_TEXT);
        this.setToolTipText(Messages._UI_CAPTURE_SCREEN_ACTION_TOOLTIPTEXT);
        this.setImageDescriptor(XSDEditorPlugin.getImageDescriptor("icons/etool16/capturescreen.gif"));
        this.setDisabledImageDescriptor(XSDEditorPlugin.getImageDescriptor("icons/dtool16/capturescreen.gif"));
        this.setAccelerator(393304);
    }

    public void run() {
        ImageExporter imageExporter = new ImageExporter();
        IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorPart iEditorPart2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageExporter.save(iEditorPart, (GraphicalViewer)iEditorPart2.getAdapter((Class)clazz));
    }

    public class ImageExporter {
        private static final String FILE_FORMATS = "*.jpeg;*.jfif;*.jpg;*.jpe;*.png;*.bmp;*.ico";
        private static final String FILE_SEPARATOR = "file.separator";

        public boolean save(IEditorPart editorPart, GraphicalViewer viewer, String saveFilePath, int format) {
            Assert.isNotNull((Object)editorPart, (String)"null editorPart passed to ImageExporter.save");
            Assert.isNotNull((Object)viewer, (String)"null viewer passed to ImageExporter.save");
            Assert.isNotNull((Object)saveFilePath, (String)"null saveFilePath passed to ImageExporter.save");
            if (format != 0 && format != 4 && format != 3 && format != 5) {
                throw new IllegalArgumentException(Messages._UI_ACTION_CAPTURE_SCREEN_FORMAT_NOT_SUPPORTED);
            }
            try {
                this.saveEditorContentsAsImage(editorPart, viewer, saveFilePath, format);
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)editorPart.getEditorSite().getShell(), (String)Messages._UI_ACTION_CAPTURE_SCREEN_ERROR_TITLE, (String)Messages._UI_ACTION_CAPTURE_SCREEN_ERROR_DESCRIPTION);
                return false;
            }
            return true;
        }

        public boolean save(IEditorPart editorPart, GraphicalViewer viewer) {
            Assert.isNotNull((Object)editorPart, (String)"null editorPart passed to ImageExporter.save");
            Assert.isNotNull((Object)viewer, (String)"null viewer passed to ImageExporter.save");
            String saveFilePath = this.getSaveFilePath(editorPart, viewer);
            if (saveFilePath == null) {
                return false;
            }
            File file = new File(saveFilePath);
            if (file.exists() && file.isFile() && !MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages._UI_ACTION_CAPTURE_SCREEN_OVERWRITE_CONFIRMATION_QUESTION, (String)Messages._UI_ACTION_CAPTURE_SCREEN_OVERWRITE_CONFIRMATION.replace("{0}", saveFilePath))) {
                return false;
            }
            int format = -1;
            String saveFilePathLowerCase = saveFilePath.toLowerCase();
            if (saveFilePathLowerCase.endsWith(".jpeg") || saveFilePathLowerCase.endsWith(".jpg") || saveFilePathLowerCase.endsWith(".jpe") || saveFilePathLowerCase.endsWith(".jfif")) {
                format = 4;
            } else if (saveFilePathLowerCase.endsWith(".bmp")) {
                format = 0;
            } else if (saveFilePathLowerCase.endsWith(".ico")) {
                format = 3;
            } else if (saveFilePathLowerCase.endsWith(".png")) {
                format = 5;
            } else if (saveFilePathLowerCase.endsWith(".gif")) {
                format = 2;
            }
            if (format != -1) {
                return this.save(editorPart, viewer, saveFilePath, format);
            }
            return false;
        }

        private String getSaveFilePath(IEditorPart editorPart, GraphicalViewer viewer) {
            FileDialog fileDialog = new FileDialog(editorPart.getEditorSite().getShell(), 8192);
            String[] filterExtensions = new String[]{FILE_FORMATS};
            fileDialog.setFileName(this.obtainNextFileName());
            fileDialog.setFilterExtensions(filterExtensions);
            fileDialog.setFilterNames(new String[]{FILE_FORMATS});
            fileDialog.setText(Messages._UI_ACTION_CAPTURE_SCREEN_FILE_SAVE_DIALOG_TITLE);
            String filePath = fileDialog.open();
            if (filePath != null) {
                LAST_SCREEN_CAPTURE_PATH = fileDialog.getFilterPath();
                String fileName = fileDialog.getFileName();
                if (fileName.indexOf(46) > 0) {
                    LAST_SCREEN_CAPTURE_FILE_NAME = fileName.substring(0, fileName.indexOf(46));
                    LAST_SCREEN_CAPTURE_FILE_EXTENSION = fileName.substring(fileName.indexOf(46));
                } else {
                    LAST_SCREEN_CAPTURE_FILE_NAME = fileName;
                    LAST_SCREEN_CAPTURE_FILE_EXTENSION = "";
                }
            }
            return filePath;
        }

        private void saveEditorContentsAsImage(IEditorPart editorPart, GraphicalViewer viewer, String saveFilePath, int format) {
            ScalableRootEditPart rootEditPart = (ScalableRootEditPart)viewer.getEditPartRegistry().get(LayerManager.ID);
            IFigure rootFigure = rootEditPart.getLayer((Object)"Printable Layers");
            Rectangle rootFigureBounds = new Rectangle(new Point(0, 0), rootFigure.getPreferredSize());
            List rootEditPartChildren = rootEditPart.getChildren();
            Iterator rootEditPartChildrenIterator = rootEditPartChildren.iterator();
            while (rootEditPartChildrenIterator.hasNext()) {
                Object object = rootEditPartChildrenIterator.next();
                if (!(object instanceof AbstractGraphicalEditPart)) continue;
                AbstractGraphicalEditPart childAbstractGraphicalEditPart = (AbstractGraphicalEditPart)object;
                List grandChildren = childAbstractGraphicalEditPart.getChildren();
                Iterator grandChildrenIterator = grandChildren.iterator();
                while (grandChildrenIterator.hasNext()) {
                    AbstractGraphicalEditPart grandChildAbstractGraphicalEditPart = (AbstractGraphicalEditPart)grandChildrenIterator.next();
                    IFigure figure = grandChildAbstractGraphicalEditPart.getFigure();
                    LayoutManager layoutManager = figure.getLayoutManager();
                    if (!(layoutManager instanceof FillLayout)) continue;
                    rootFigureBounds = rootFigure.getBounds();
                }
            }
            Control figureCanvas = viewer.getControl();
            GC figureCanvasGC = new GC((Drawable)figureCanvas);
            Image img = new Image(null, rootFigureBounds.width, rootFigureBounds.height);
            GC imageGC = new GC((Drawable)img);
            imageGC.setBackground(figureCanvasGC.getBackground());
            imageGC.setForeground(figureCanvasGC.getForeground());
            imageGC.setFont(figureCanvasGC.getFont());
            imageGC.setLineStyle(figureCanvasGC.getLineStyle());
            imageGC.setLineWidth(figureCanvasGC.getLineWidth());
            imageGC.setXORMode(figureCanvasGC.getXORMode());
            SWTGraphics imgGraphics = new SWTGraphics(imageGC);
            rootFigure.paint((Graphics)imgGraphics);
            ImageData[] imgData = new ImageData[]{img.getImageData()};
            ImageLoader imgLoader = new ImageLoader();
            imgLoader.data = imgData;
            imgLoader.save(saveFilePath, format);
            figureCanvasGC.dispose();
            imageGC.dispose();
            img.dispose();
        }

        String obtainNextFileName() {
            int aux = LAST_SCREEN_CAPTURE_FILE_NAME.length() - 1;
            while (Character.isDigit(LAST_SCREEN_CAPTURE_FILE_NAME.charAt(aux))) {
                --aux;
            }
            String nonNumeratedfileName = LAST_SCREEN_CAPTURE_FILE_NAME.substring(0, aux + 1);
            String filePath = String.valueOf(LAST_SCREEN_CAPTURE_PATH) + System.getProperty(FILE_SEPARATOR) + nonNumeratedfileName + LAST_SCREEN_CAPTURE_FILE_EXTENSION;
            int counter = 1;
            File file = new File(filePath);
            while (file.exists()) {
                filePath = String.valueOf(LAST_SCREEN_CAPTURE_PATH) + System.getProperty(FILE_SEPARATOR) + nonNumeratedfileName + counter++ + LAST_SCREEN_CAPTURE_FILE_EXTENSION;
                file = new File(filePath);
            }
            return filePath;
        }
    }
}

