/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUnsignedInt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSUnsignedShort
extends XSUnsignedInt {
    private static final String XS_UNSIGNED_SHORT = "xs:unsignedShort";

    public XSUnsignedShort() {
        this(BigInteger.valueOf(0L));
    }

    public XSUnsignedShort(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_UNSIGNED_SHORT;
    }

    public String type_name() {
        return "unsignedShort";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.getStringValue());
            BigInteger min = BigInteger.valueOf(0L);
            BigInteger max = BigInteger.valueOf(65535L);
            if (bigInt.compareTo(min) < 0 || bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            return new XSUnsignedShort(bigInt);
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_UNSIGNEDSHORT;
    }

    public Number getNativeValue() {
        return this.getValue().intValue();
    }
}

