/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Element;

public class WSI2100
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean containsClaims = false;
    private ErrorList errors = new ErrorList();

    public WSI2100(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(Port port, Object parent, WSDLTraversalContext ctx) {
        if (port != null && !this.containsLegalClaim(port.getDocumentationElement())) {
            this.errors.add(WSDL_PORT, port.getName());
        }
    }

    @Override
    public void visit(Binding binding, Object parent, WSDLTraversalContext ctx) {
        if (binding != null && !this.containsLegalClaim(binding.getDocumentationElement())) {
            this.errors.add(WSDL_BINDING, binding.getQName());
        }
    }

    @Override
    public void visit(PortType type, Object parent, WSDLTraversalContext ctx) {
        if (type != null && !this.containsLegalClaim(type.getDocumentationElement())) {
            this.errors.add(WSDL_PORTTYPE, type.getQName());
        }
    }

    @Override
    public void visit(Operation operation, Object parent, WSDLTraversalContext ctx) {
        if (operation != null && !this.containsLegalClaim(operation.getDocumentationElement())) {
            this.errors.add(WSDL_OPERATION, operation.getName());
        }
    }

    @Override
    public void visit(Message message, Object parent, WSDLTraversalContext ctx) {
        if (message != null && !this.containsLegalClaim(message.getDocumentationElement())) {
            this.errors.add(WSDL_MESSAGE, message.getQName());
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitOperation(true);
        traversal.visitBinding(true);
        traversal.visitMessage(true);
        traversal.visitPort(true);
        traversal.visitPortType(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
            this.result = "failed";
        } else {
            this.result = !this.containsClaims ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsLegalClaim(Element el) {
        if (el == null) {
            return true;
        }
        if ((el = XMLUtils.findChildElement(el, WSI_CLAIM)) != null) {
            this.containsClaims = true;
        }
        while (el != null) {
            if (XMLUtils.getAttribute(el, ATTR_CLAIM_CONFORMSTO) == null || XMLUtils.getAttribute(el, ATTR_SOAP_MUSTUNDERSTAND) != null) {
                return false;
            }
            el = XMLUtils.findElement(el, WSI_CLAIM);
        }
        return true;
    }
}

