/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class BP2019
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2019(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        boolean docLitFound = false;
        String errantElements = new String("");
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPBinding soapBinding = WSDLValidatorImpl.getSoapBinding(binding);
        if (soapBinding != null) {
            String style;
            String string = style = soapBinding.getStyle() == null ? "document" : soapBinding.getStyle();
            if (style.equals("document")) {
                Vector soapElements = Utils.arrayToVector(this.validator.getSoapBodies(binding));
                soapElements.addAll(Utils.arrayToVector(this.validator.getSoapFaults(binding)));
                soapElements.addAll(Utils.arrayToVector(this.validator.getSoapHeaders(binding)));
                soapElements.addAll(Utils.arrayToVector(this.validator.getSoapHeaderFaults(binding)));
                for (ExtensibilityElement soapElement : soapElements) {
                    try {
                        if (!this.validator.isLiteral(soapElement)) continue;
                        docLitFound = true;
                        if (!this.validator.namespaceFoundInSoapLiteral(soapElement)) continue;
                        errantElements = String.valueOf(errantElements) + "\n--- " + soapElement.toString();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (!docLitFound) {
            this.result = "notApplicable";
        } else if (errantElements.length() != 0) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail("Failing elements:" + errantElements, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

