/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BP1302
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1302(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String responseMessage = null;
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            MessageEntry logEntryResponse = entryContext.getResponse();
            if (logEntryResponse != null) {
                responseMessage = logEntryResponse.getMessage();
                Document targetDoc = XMLUtils.parseXML(responseMessage);
                NodeList faultCodes = targetDoc.getElementsByTagName("faultcode");
                if (faultCodes.getLength() <= 0) {
                    this.result = "notApplicable";
                }
                int i = 0;
                while (i < faultCodes.getLength()) {
                    Node faultCodeElem = faultCodes.item(i);
                    if (faultCodeElem == null) {
                        this.result = "notApplicable";
                    } else if (faultCodeElem.getNodeType() == 1) {
                        if (this.isValidFaultCode((Element)faultCodeElem)) {
                            this.result = "passed";
                        } else {
                            this.result = "warning";
                            this.failureDetail = this.validator.createFailureDetail(responseMessage, entryContext);
                        }
                    } else {
                        this.result = "notApplicable";
                    }
                    ++i;
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    public boolean isValidFaultCode(Element faultCodeElem) {
        if (faultCodeElem == null) {
            return true;
        }
        String faultCode = faultCodeElem.getFirstChild().getNodeValue().trim();
        if (faultCode == null) {
            return false;
        }
        String faultCodeElemPrefix = faultCodeElem.getParentNode().getPrefix();
        String faultCodePrefix = null;
        String faultCodeName = faultCode;
        int index = faultCode.indexOf(58);
        if (index != -1) {
            faultCodePrefix = faultCode.substring(0, index);
            faultCodeName = faultCode.substring(index + 1, faultCode.length());
        }
        if (faultCodeElemPrefix != null && faultCodePrefix != null) {
            if (faultCodePrefix.equals(faultCodeElemPrefix)) {
                return faultCodeName.equals("MustUnderstand") || faultCodeName.equals("VersionMismatch") || faultCodeName.equals("Client") || faultCodeName.equals("Server");
            }
            return true;
        }
        return faultCodeName.equals("MustUnderstand") || faultCodeName.equals("VersionMismatch") || faultCodeName.equals("Client") || faultCodeName.equals("Server") || faultCodeName.startsWith("MustUnderstand.") || faultCodeName.startsWith("VersionMismatch.") || faultCodeName.startsWith("Client.") || faultCodeName.startsWith("Server.");
    }
}

