/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.envelope;

import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.EntryType;

public class AP1920
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public AP1920(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (!entryContext.getMessageEntry().isMimeContent()) {
                throw new AssertionNotApplicableException();
            }
            if (entryContext.getMessageEntryDocument() == null || entryContext.getMessageEntryDocument().getElementsByTagNameNS(WSITag.ELEM_SOAP_FAULT.getNamespaceURI(), WSITag.ELEM_SOAP_FAULT.getLocalPart()).getLength() != 1) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = this.validator.getOperationMatch(EntryType.getEntryType("requestMessage"), entryContext.getRequestDocument());
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            if (entryContext.getMessageEntry().getMimeParts().count() > 1 && this.getMultipartRelatedBindings(bindingOperation) == null) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("The message contains \"" + entryContext.getMessageEntry().getMimeParts().count() + "\" part(s)", entryContext);
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private MIMEMultipartRelated getMultipartRelatedBindings(BindingOperation op) {
        List extElems = op.getBindingOutput().getExtensibilityElements();
        if (extElems == null || extElems.size() == 0 || !(extElems.get(0) instanceof MIMEMultipartRelated)) {
            return null;
        }
        return (MIMEMultipartRelated)extElems.get(0);
    }
}

