/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.extensions.INodeAssociationProvider;
import org.eclipse.wst.wsdl.ui.internal.extensions.WSDLNodeAssociationProvider;
import org.eclipse.wst.wsdl.ui.internal.xsd.XSDNodeAssociationProvider;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NodeAssociationManager {
    protected INodeAssociationProvider wsdlProvider = new WSDLNodeAssociationProvider();
    protected INodeAssociationProvider xsdProvider = new XSDNodeAssociationProvider();

    protected INodeAssociationProvider getAppicableProvider(Object object) {
        if (object instanceof XSDSchemaExtensibilityElement || object instanceof XSDConcreteComponent || object instanceof CategoryAdapter) {
            return this.xsdProvider;
        }
        return this.wsdlProvider;
    }

    public Object getModelObjectForNode(Object rootObject, Element targetNode) {
        if (targetNode != null && targetNode.getParentNode() == null) {
            return null;
        }
        int currentIndex = 0;
        Element[] elementChain = this.getParentElementChain(targetNode);
        INodeAssociationProvider p = this.getAppicableProvider(rootObject);
        if (p != null) {
            Node rootObjectNode = p.getNode(rootObject);
            while (currentIndex < elementChain.length) {
                Element e = elementChain[currentIndex];
                if (e == rootObjectNode) {
                    ++currentIndex;
                    break;
                }
                ++currentIndex;
            }
        }
        Object currentObject = rootObject;
        int[] end = new int[1];
        while (currentIndex < elementChain.length) {
            p = this.getAppicableProvider(currentObject);
            if (p == null) break;
            end[0] = elementChain.length;
            if ((currentObject = p.getModelObject(currentObject, elementChain, currentIndex, end)) == null) break;
            currentIndex = Math.max(end[0], currentIndex + 1);
        }
        return currentIndex == elementChain.length ? currentObject : null;
    }

    public Node getNode(Object modelObject) {
        Node result = null;
        if (modelObject instanceof Node) {
            result = (Node)modelObject;
        } else {
            INodeAssociationProvider p = this.getAppicableProvider(modelObject);
            if (p != null) {
                result = p.getNode(modelObject);
            }
        }
        return result;
    }

    protected Element[] getParentElementChain(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (element != null) {
            list.add(0, element);
            Node node = element.getParentNode();
            Element element2 = element = node != null && node.getNodeType() == 1 ? (Element)node : null;
        }
        int listSize = list.size();
        Element[] result = new Element[listSize];
        int i = 0;
        while (i < listSize) {
            result[i] = (Element)list.get(i);
            ++i;
        }
        return result;
    }
}

