/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.core.search.scope.SearchScope;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentList;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentSearchListProvider;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.internal.impl.ImportImpl;
import org.eclipse.wst.wsdl.ui.internal.edit.WSDLComponentFinder;

public abstract class WSDLBaseSearchListProvider
implements IComponentSearchListProvider {
    protected Definition definition;

    protected void createWSDLComponentObjects(IComponentList list, List inputComponents, QualifiedName metaName) {
        for (WSDLElement wsdlElement : inputComponents) {
            String name = wsdlElement.getElement().getAttribute("name");
            String qualifier = wsdlElement.getEnclosingDefinition().getTargetNamespace();
            ComponentSpecification componentSpec = new ComponentSpecification();
            componentSpec.setMetaName(metaName);
            componentSpec.setName(name);
            componentSpec.setQualifier(qualifier);
            String location = wsdlElement.getEnclosingDefinition().getLocation();
            String platformResource = "platform:/resource";
            if (location != null && location.startsWith(platformResource)) {
                Path path = new Path(location.substring(platformResource.length()));
                IFile result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                if (result != null) {
                    componentSpec.setFile(result);
                }
            }
            list.add((Object)componentSpec);
        }
    }

    protected List getWSDLFileImports(List wsdlImports) {
        ArrayList<ImportImpl> list = new ArrayList<ImportImpl>();
        for (ImportImpl importItem : wsdlImports) {
            importItem.importDefinitionOrSchema();
            if (importItem.getESchema() != null) continue;
            list.add(importItem);
        }
        return list;
    }

    protected List getSearchingComponents(Definition importDefinition) {
        return new ArrayList();
    }

    protected void getImportedComponents(IComponentList list, QualifiedName metaName, HashMap exclusions) {
        for (Import importItem : this.getWSDLFileImports((List)this.definition.getEImports())) {
            String location = importItem.getDefinition().getDocumentBaseURI();
            exclusions.put(location, Boolean.TRUE);
            Definition importDefinition = importItem.getEDefinition();
            if (importDefinition == null) continue;
            List importedComponents = this.getSearchingComponents(importDefinition);
            this.createWSDLComponentObjects(list, importedComponents, metaName);
        }
    }

    protected void searchOutsideCurrentResource(IComponentList list, SearchScope scope, QualifiedName metaName, Map exclusions) {
        if (scope != null) {
            WSDLComponentFinder finder = new WSDLComponentFinder(metaName);
            for (ComponentSpecification item : finder.getWorkbenchResourceComponents(scope)) {
                String itemURI = URIHelper.getPlatformURI((IResource)item.getFile());
                if (exclusions.get(itemURI) != null) continue;
                list.add((Object)item);
            }
        }
    }
}

