/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDLabelDirectEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.HeadingFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IService;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;

public class ServiceEditPart
extends BaseEditPart
implements INamedEditPart {
    IFigure contentPane;
    HeadingFigure headingFigure;
    private DirectEditManager manager;

    @Override
    public void addFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(2);
        this.headingFigure.setSelected(true);
        this.figure.repaint();
    }

    @Override
    public void removeFeedback() {
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(1);
        boxFigureLineBorder.setColor(DesignViewGraphicsConstants.defaultForegroundColor);
        this.headingFigure.setSelected(false);
        this.figure.repaint();
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        figure.setBorder((Border)new LineBorder(1));
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        figure.setLayoutManager((LayoutManager)toolbarLayout);
        this.headingFigure = new HeadingFigure();
        if (this.getModel() instanceof ITreeElement) {
            this.headingFigure.getLabel().setIcon(((ITreeElement)this.getModel()).getImage());
        }
        figure.add((IFigure)this.headingFigure);
        this.contentPane = new Figure(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                boolean isFirst = false;
                for (Figure figure : this.getChildren()) {
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    Rectangle r = figure.getBounds();
                    graphics.drawLine(r.x, r.y + 1, r.x + r.width, r.y + 1);
                }
            }
        };
        ToolbarLayout toolbarLayout2 = new ToolbarLayout(false);
        toolbarLayout2.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout2);
        figure.add(this.contentPane);
        if (this.isReadOnly()) {
            this.headingFigure.getLabel().setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.headingFigure.getLabel().setForegroundColor(ColorConstants.black);
        }
        return figure;
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ASDLabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    @Override
    public void performDirectEdit(Point cursorLocation) {
        if (!this.isFileReadOnly() && (cursorLocation == null || this.hitTest(this.headingFigure.getLabel(), cursorLocation) && !this.isReadOnly())) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, cursorLocation));
            this.manager.show();
        } else if ((this.hitTest(this.headingFigure.getLabel(), cursorLocation) || this.hitTestFigure(this.headingFigure, cursorLocation)) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit(null);
        }
    }

    @Override
    public Label getLabelFigure() {
        return this.headingFigure.getLabel();
    }

    protected List getModelChildren() {
        IService service = (IService)this.getModel();
        return service.getEndPoints();
    }

    protected void refreshVisuals() {
        IService service = (IService)this.getModel();
        this.headingFigure.setIsReadOnly(service.isReadOnly());
        this.headingFigure.getLabel().setText(service.getName());
        super.refreshVisuals();
    }

    @Override
    protected String getAccessibleName() {
        Label labelFigure = this.getLabelFigure();
        if (labelFigure != null) {
            return labelFigure.getText();
        }
        return "";
    }

    @Override
    public EditPart getRelativeEditPart(int direction) {
        if (direction == 1) {
            return EditPartNavigationHandlerUtil.getPrevSibling((EditPart)this);
        }
        if (direction == 16) {
            return EditPartNavigationHandlerUtil.getFirstBinding((EditPart)this);
        }
        return super.getRelativeEditPart(direction);
    }
}

