/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.registry;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.ws.internal.model.v10.registry.DocumentRoot;
import org.eclipse.wst.ws.internal.model.v10.registry.Registry;
import org.eclipse.wst.ws.internal.model.v10.registry.RegistryFactory;
import org.eclipse.wst.ws.internal.model.v10.registry.RegistryPackage;
import org.eclipse.wst.ws.internal.model.v10.rtindex.RTIndexPackage;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.TaxonomyFactory;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.TaxonomyPackage;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.registry.GenericResourceFactory;
import org.eclipse.wst.ws.internal.registry.IRegistryManager;
import org.eclipse.wst.ws.internal.registry.RegistryManager;

public class RegistryService {
    private static RegistryService instance_;
    private static final String DEFAULT_INDEX_XML_FILE = "DefaultIndex.xml";
    private Hashtable registryManagers_ = new Hashtable();
    private IRegistryManager defaultRegistryManager_ = null;
    private GenericResourceFactory resourceFactory_ = new GenericResourceFactory();

    private RegistryService() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xml", this.resourceFactory_);
        RegistryPackage.eINSTANCE.getClass();
        TaxonomyPackage.eINSTANCE.getClass();
        RTIndexPackage.eINSTANCE.getClass();
    }

    public static RegistryService instance() {
        if (instance_ == null) {
            instance_ = new RegistryService();
        }
        return instance_;
    }

    public IRegistryManager getDefaultRegistryManager() {
        if (this.defaultRegistryManager_ == null) {
            String indexFilename = WSPlugin.getDefault().getStateLocation().append(DEFAULT_INDEX_XML_FILE).toString();
            this.defaultRegistryManager_ = new RegistryManager(indexFilename);
        }
        return this.defaultRegistryManager_;
    }

    public IRegistryManager getRegistryManager(URL url) {
        IRegistryManager registryManager = (IRegistryManager)this.registryManagers_.get(url);
        if (registryManager == null) {
            registryManager = new RegistryManager(url);
            this.registryManagers_.put(url, registryManager);
        }
        return registryManager;
    }

    public void removeRegistryManager(URL url) {
        this.registryManagers_.remove(url);
    }

    public Registry newRegistry() {
        return RegistryFactory.eINSTANCE.createRegistry();
    }

    public Registry loadRegistry(URL url) throws CoreException {
        Resource resource = this.resourceFactory_.createResource(URI.createURI((String)"*.xml"));
        try {
            resource.load(RegistryService.getInputStreamFor(url), null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
        }
        DocumentRoot document = (DocumentRoot)resource.getContents().get(0);
        return document.getRegistry();
    }

    public void saveRegistry(URL url, Registry registry) throws CoreException {
        DocumentRoot document = RegistryFactory.eINSTANCE.createDocumentRoot();
        document.setRegistry(registry);
        Resource resource = this.resourceFactory_.createResource(URI.createURI((String)"*.xml"));
        resource.getContents().add((Object)document);
        try {
            resource.save(RegistryService.getOutputStreamFor(url), null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
        }
    }

    public Taxonomy newTaxonomy() {
        return TaxonomyFactory.eINSTANCE.createTaxonomy();
    }

    public Taxonomy loadTaxonomy(URL url) throws CoreException {
        Resource resource = this.resourceFactory_.createResource(URI.createURI((String)"*.xml"));
        try {
            resource.load(RegistryService.getInputStreamFor(url), null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
        }
        org.eclipse.wst.ws.internal.model.v10.taxonomy.DocumentRoot document = (org.eclipse.wst.ws.internal.model.v10.taxonomy.DocumentRoot)resource.getContents().get(0);
        return document.getTaxonomy();
    }

    public void saveTaxonomy(URL url, Taxonomy taxonomy) throws CoreException {
        org.eclipse.wst.ws.internal.model.v10.taxonomy.DocumentRoot document = TaxonomyFactory.eINSTANCE.createDocumentRoot();
        document.setTaxonomy(taxonomy);
        Resource resource = this.resourceFactory_.createResource(URI.createURI((String)"*.xml"));
        resource.getContents().add((Object)document);
        try {
            resource.save(RegistryService.getOutputStreamFor(url), null);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.ws", 0, "", (Throwable)e));
        }
    }

    public Registry newRegistryReference(Registry registry) {
        String id = registry.getId();
        String ref = registry.getRef();
        Registry registryRef = this.newRegistry();
        if (ref == null || "".equals(ref)) {
            registryRef.setRef(id);
        } else {
            registryRef.setRef(ref);
            registryRef.setLocation(registry.getLocation());
        }
        return registryRef;
    }

    public Taxonomy newTaxonomyReference(Taxonomy taxonomy) {
        String id = taxonomy.getId();
        String ref = taxonomy.getRef();
        Taxonomy taxonomyRef = this.newTaxonomy();
        if (ref == null || "".equals(ref)) {
            taxonomyRef.setRef(id);
        } else {
            taxonomyRef.setRef(ref);
            taxonomyRef.setLocation(taxonomy.getLocation());
        }
        return taxonomyRef;
    }

    static boolean exists(URL url) {
        if ("platform".equals(url.getProtocol())) {
            String urlFile = url.getFile().trim();
            IPath path = new Path(urlFile).removeFirstSegments(1);
            if (path.segmentCount() <= 1) {
                return false;
            }
            IPath osPath = ResourcesPlugin.getWorkspace().getRoot().getFile(path).getLocation();
            if (osPath == null) {
                return false;
            }
            File file = new File(osPath.toString());
            return file.exists() && !file.isDirectory();
        }
        if ("file".equals(url.getProtocol())) {
            File file = new File(url.getFile().trim());
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    static OutputStream getOutputStreamFor(URL url) throws IOException {
        OutputStream outputStream = null;
        if ("platform".equals(url.getProtocol())) {
            String urlFile = url.getFile().trim();
            IPath path = new Path(urlFile).removeFirstSegments(1);
            if (path.segmentCount() <= 1) {
                throw new IOException("The Platform URL {0} is not bound to a local, writable file.");
            }
            IPath osPath = ResourcesPlugin.getWorkspace().getRoot().getFile(path).getLocation();
            if (osPath == null) {
                throw new IOException("The Platform URL {0} is not bound to a local, writable file.");
            }
            File file = new File(osPath.toString());
            if (file.isDirectory()) {
                throw new IOException("The Platform URL {0} is bound to a folder.");
            }
            outputStream = new FileOutputStream(file);
        } else if ("file".equals(url.getProtocol())) {
            File file = new File(url.getFile().trim());
            if (file.isDirectory()) {
                throw new IOException("The File URL {0} is bound to a directory.");
            }
            outputStream = new FileOutputStream(file);
        } else {
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            outputStream = connection.getOutputStream();
        }
        return outputStream;
    }

    static InputStream getInputStreamFor(URL url) throws IOException {
        return url.openStream();
    }
}

