/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.Choice;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.ws.internal.WstWSPluginMessages;
import org.eclipse.wst.ws.internal.preferences.PersistentWSIContext;

public class WSIComplianceUtils {
    public static int getWSISeverity(IProject project, PersistentWSIContext context) {
        if (context.projectStopNonWSICompliances(project)) {
            return 4;
        }
        if (context.projectWarnNonWSICompliances(project)) {
            return 2;
        }
        return 1;
    }

    public static boolean checkWSICompliance(IStatusHandler monitor, Status[] status, IProject project, PersistentWSIContext context) {
        if (context.projectStopNonWSICompliances(project)) {
            MultiStatus status_ = StatusUtils.multiStatus((String)context.getError(), (IStatus[])status);
            monitor.reportError((IStatus)status_);
            return false;
        }
        if (context.projectWarnNonWSICompliances(project)) {
            Choice cancelChoice;
            Choice ignoreAllChoice;
            Choice ignoreChoice;
            MultiStatus status_ = StatusUtils.multiStatus((String)context.getWarning(), (IStatus[])status);
            Choice result = monitor.report((IStatus)status_, new Choice[]{ignoreChoice = new Choice('I', WstWSPluginMessages.IGNORE_LABEL, WstWSPluginMessages.IGNORE_DESCRIPTION), ignoreAllChoice = new Choice('A', WstWSPluginMessages.IGNORE_ALL_LABEL, WstWSPluginMessages.IGNORE_ALL_DESCRIPTION), cancelChoice = new Choice('C', WstWSPluginMessages.CANCEL_LABEL, WstWSPluginMessages.CANCEL_DESCRIPTION)});
            if (result == null || result.getLabel().equals(cancelChoice.getLabel())) {
                return false;
            }
            if (result.getLabel().equals(ignoreChoice.getLabel())) {
                return true;
            }
            if (result.getLabel().equals(ignoreAllChoice.getLabel())) {
                context.updateProjectWSICompliances(project, "2");
                return true;
            }
        }
        return true;
    }
}

