/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.eclipse.wst.ws.internal.datamodel.BasicModel;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryElement;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Category;
import org.eclipse.wst.ws.internal.model.v10.taxonomy.Taxonomy;
import org.uddi4j.util.KeyedReference;

public class CategoryModel
extends BasicModel {
    private ServletContext application_ = null;
    private String defaultDataFile_ = null;
    private Hashtable categoryElements_ = null;
    private String columnDelimiter_ = "#";
    private String stringDelimiter_ = "\"";
    private String categoryKey_ = null;
    private boolean checked_ = true;
    private String displayName_ = null;
    private String tModelKey_ = null;
    private Throwable errorException_ = null;
    public static final byte OPERATION_SUCCESSFUL = 0;
    public static final byte ERROR_FILE = 1;
    public static final byte ERROR_SECURITY = 2;
    public static final byte ERROR_ENCODING = 3;
    public static final byte ERROR_IO = 4;
    public static final byte ERROR_CATEGORY_KEY = 5;
    private final String defaultColumnDelimiter_ = "#";
    private final String defaultStringDelimiter_ = "\"";

    public CategoryModel() {
        super("categories");
    }

    public final void setServletContext(ServletContext application) {
        this.application_ = application;
    }

    public final void setDefaultDataFile(String defaultDataFile) {
        this.defaultDataFile_ = defaultDataFile;
    }

    public final void setCategoryKey(String categoryKey) {
        this.categoryKey_ = categoryKey;
    }

    public final String getCategoryKey() {
        return this.categoryKey_;
    }

    public final void setColumnDelimiter(String columnDelimiter) {
        this.columnDelimiter_ = columnDelimiter;
    }

    public final String getColumnDelimiter() {
        return this.columnDelimiter_;
    }

    public final void setStringDelimiter(String stringDelimiter) {
        this.stringDelimiter_ = stringDelimiter;
    }

    public final String getStringDelimiter() {
        return this.stringDelimiter_;
    }

    public final void enableChecked(boolean isChecked) {
        this.checked_ = isChecked;
    }

    public final boolean isChecked() {
        return this.checked_;
    }

    public final void setDisplayName(String displayName) {
        this.displayName_ = displayName;
    }

    public final String getDisplayName() {
        return this.displayName_;
    }

    public final void setTModelKey(String tModelKey) {
        this.tModelKey_ = tModelKey;
    }

    public final String getTModelKey() {
        return this.tModelKey_;
    }

    public final boolean isDataLoaded() {
        return this.categoryElements_ != null;
    }

    public final Throwable getErrorException() {
        return this.errorException_;
    }

    private final boolean isEnclosedInQuotes(String string) {
        return string.startsWith("\"") && string.endsWith("\"");
    }

    public final void loadFromTaxonomy(Taxonomy taxonomy) {
        String name = taxonomy.getName();
        CategoryElement root = new CategoryElement(name, null, (Model)this);
        this.setRootElement((Element)root);
        this.categoryElements_ = new Hashtable();
        Iterator it = taxonomy.getCategory().iterator();
        while (it.hasNext()) {
            this.addCategory(root, (Category)it.next());
        }
    }

    private void addCategory(CategoryElement parent, Category category) {
        String keyName = category.getName();
        String keyValue = category.getCode();
        CategoryElement child = new CategoryElement(keyName, new KeyedReference(keyName, keyValue, this.tModelKey_), (Model)this);
        parent.connect((Element)child, "subCategories", "owner");
        this.categoryElements_.put(keyValue, child);
        Iterator it = category.getCategory().iterator();
        while (it.hasNext()) {
            this.addCategory(child, (Category)it.next());
        }
    }

    public final byte loadFromDefaultDataFile() {
        try {
            if (this.defaultDataFile_ == null) {
                throw new FileNotFoundException();
            }
            BufferedReader br = null;
            br = this.application_ == null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.defaultDataFile_), "UTF-8")) : new BufferedReader(new InputStreamReader(this.application_.getResourceAsStream(this.defaultDataFile_), "UTF-8"));
            return this.loadData(br);
        }
        catch (FileNotFoundException e) {
            this.errorException_ = e;
            return 1;
        }
        catch (SecurityException e) {
            this.errorException_ = e;
            return 2;
        }
        catch (UnsupportedEncodingException e) {
            this.errorException_ = e;
            return 3;
        }
    }

    public final byte loadFromDelimiterFile() {
        try {
            Properties p = new Properties();
            InputStream fin = null;
            fin = this.application_ == null ? new FileInputStream(this.defaultDataFile_) : this.application_.getResourceAsStream(this.defaultDataFile_);
            p.load(fin);
            fin.close();
            this.columnDelimiter_ = p.getProperty("column.delimiter");
            this.stringDelimiter_ = p.getProperty("string.delimiter");
            this.defaultDataFile_ = p.getProperty("wsad.dataFile");
            return this.loadFromDefaultDataFile();
        }
        catch (FileNotFoundException e) {
            this.errorException_ = e;
            return 1;
        }
        catch (SecurityException e) {
            this.errorException_ = e;
            return 2;
        }
        catch (IOException e) {
            this.errorException_ = e;
            return 4;
        }
    }

    public final byte loadData(BufferedReader br) {
        this.errorException_ = null;
        CategoryElement rootElement = null;
        this.categoryElements_ = new Hashtable();
        byte returnCode = 0;
        String line = null;
        int lineNumber = 0;
        try {
            char columnDelimiterChar = this.columnDelimiter_.charAt(0);
            char stringDelimiterChar = this.stringDelimiter_.charAt(0);
            Vector<String> values = new Vector<String>();
            while ((line = br.readLine()) != null) {
                ++lineNumber;
                if (line.trim().length() == 0) continue;
                int index = 0;
                int length = line.length();
                boolean inStringDelimiters = false;
                values.removeAllElements();
                StringBuffer currentToken = new StringBuffer();
                while (index < length) {
                    char currentChar = line.charAt(index);
                    if (inStringDelimiters) {
                        if (currentChar == stringDelimiterChar) {
                            if (index < length - 1) {
                                char followingChar = line.charAt(index + 1);
                                if (followingChar == stringDelimiterChar) {
                                    currentToken.append(stringDelimiterChar);
                                    index += 2;
                                    continue;
                                }
                                inStringDelimiters = false;
                                int nextDelimiter = line.indexOf(columnDelimiterChar, index);
                                if (nextDelimiter == -1) break;
                                values.addElement(currentToken.toString());
                                currentToken.setLength(0);
                                inStringDelimiters = false;
                                index = nextDelimiter + 1;
                                continue;
                            }
                            ++index;
                            inStringDelimiters = false;
                            continue;
                        }
                        currentToken.append(currentChar);
                        ++index;
                        continue;
                    }
                    if (currentChar == columnDelimiterChar) {
                        values.addElement(currentToken.toString());
                        currentToken.setLength(0);
                        ++index;
                        continue;
                    }
                    if (currentChar == stringDelimiterChar) {
                        inStringDelimiters = true;
                        ++index;
                        continue;
                    }
                    currentToken.append(currentChar);
                    ++index;
                }
                if (inStringDelimiters) {
                    br.close();
                    throw new ParseException(line, lineNumber);
                }
                values.addElement(currentToken.toString());
                if (values.size() == 3) {
                    if (this.categoryKey_ != null) {
                        values.insertElementAt(this.categoryKey_, 0);
                    } else {
                        values.insertElementAt(this.tModelKey_, 0);
                    }
                }
                if (values.size() == 4) {
                    CategoryElement categoryElement;
                    String categoryKey = (String)values.elementAt(0);
                    if (this.categoryKey_ == null) {
                        this.categoryKey_ = categoryKey;
                    } else if (!this.categoryKey_.equals(categoryKey)) {
                        throw new Exception(categoryKey);
                    }
                    String keyValue = (String)values.elementAt(1);
                    String keyName = (String)values.elementAt(2);
                    String parentKeyValue = (String)values.elementAt(3);
                    if (rootElement == null) {
                        rootElement = new CategoryElement(this.displayName_, null, (Model)this);
                        this.setRootElement((Element)rootElement);
                    }
                    if (this.isEnclosedInQuotes(keyName)) {
                        keyName = keyName.substring(1, keyName.length() - 1);
                    }
                    if ((categoryElement = (CategoryElement)((Object)this.categoryElements_.get(keyValue))) != null) {
                        categoryElement.updateCategory(keyName, keyValue, this.tModelKey_);
                    } else {
                        categoryElement = new CategoryElement(keyName, new KeyedReference(keyName, keyValue, this.tModelKey_), (Model)this);
                    }
                    CategoryElement parentElement = parentKeyValue.equals(keyValue) ? rootElement : (Element)this.categoryElements_.get(parentKeyValue);
                    if (parentElement == null) {
                        parentElement = new CategoryElement("temp", new KeyedReference("", parentKeyValue, this.tModelKey_), (Model)this);
                        this.categoryElements_.put(parentKeyValue, parentElement);
                    } else {
                        parentElement.connect((Element)categoryElement, "subCategories", "owner");
                    }
                    this.categoryElements_.put(keyValue, categoryElement);
                    continue;
                }
                br.close();
                throw new ParseException(line, lineNumber);
            }
            br.close();
            return returnCode;
        }
        catch (IOException e) {
            this.errorException_ = e;
            returnCode = 4;
        }
        catch (ParseException e) {
            this.errorException_ = e;
            returnCode = 1;
        }
        catch (Exception e) {
            this.errorException_ = e;
            returnCode = 5;
        }
        this.categoryElements_ = null;
        return returnCode;
    }

    private final void saveData(PrintWriter pw, CategoryElement categoryElement, CategoryElement parentElement, boolean isFirst) {
        Enumeration e;
        KeyedReference kr = categoryElement.getCategory();
        if (kr != null) {
            KeyedReference parentKr;
            String keyName = kr.getKeyName();
            String keyValue = kr.getKeyValue();
            String parentKeyValue = parentElement == null ? keyValue : ((parentKr = parentElement.getCategory()) == null ? keyValue : parentKr.getKeyValue());
            if (!isFirst) {
                pw.println();
            } else {
                isFirst = false;
            }
            pw.print(this.mangle(this.categoryKey_));
            pw.print(this.columnDelimiter_);
            pw.print(this.mangle(keyValue));
            pw.print(this.columnDelimiter_);
            pw.print(this.mangle(keyName));
            pw.print(this.columnDelimiter_);
            pw.print(this.mangle(parentKeyValue));
        }
        if ((e = categoryElement.getElements("subCategories")) != null) {
            while (e.hasMoreElements()) {
                this.saveData(pw, (CategoryElement)((Object)e.nextElement()), categoryElement, isFirst);
            }
        }
    }

    private final String mangle(String input) {
        if (input != null && input.indexOf(this.columnDelimiter_) != -1) {
            StringBuffer s = new StringBuffer(input);
            s.insert(0, this.stringDelimiter_).append(this.stringDelimiter_);
            return s.toString();
        }
        return input;
    }

    public final byte saveData(String fileName) {
        int returnCode = 0;
        this.errorException_ = null;
        if (this.isDataLoaded()) {
            try {
                PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"), true);
                CategoryElement rootElement = (CategoryElement)this.getRootElement();
                this.saveData(pw, rootElement, null, true);
                pw.flush();
                pw.close();
                Properties p = new Properties();
                p.setProperty("wsad.dataFile", fileName);
                p.setProperty("wsad.checked", String.valueOf(this.checked_));
                p.setProperty("wsad.name", this.displayName_);
                p.setProperty("column.delimiter", this.columnDelimiter_);
                p.setProperty("string.delimiter", this.stringDelimiter_);
                StringBuffer propertiesFileName = new StringBuffer(fileName.substring(0, fileName.lastIndexOf(46)));
                propertiesFileName.append(".properties");
                FileOutputStream fout = new FileOutputStream(propertiesFileName.toString());
                p.store(fout, null);
                fout.close();
            }
            catch (FileNotFoundException e) {
                this.errorException_ = e;
                returnCode = 1;
            }
            catch (SecurityException e) {
                this.errorException_ = e;
                returnCode = 2;
            }
            catch (UnsupportedEncodingException e) {
                this.errorException_ = e;
                returnCode = 3;
            }
            catch (IOException e) {
                this.errorException_ = e;
                returnCode = 4;
            }
        }
        return (byte)returnCode;
    }

    public String toString() {
        return this.displayName_;
    }
}

