/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.cleanup;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupHandler;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.format.IFormattingDelegate;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractStructuredCleanupProcessor
implements IStructuredCleanupProcessor {
    public boolean refreshCleanupPreferences = true;
    private static IFormattingDelegate delegate;

    @Override
    public String cleanupContent(String input) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
            String id = String.valueOf(inputStream.toString()) + this.getContentType();
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
            this.cleanupModel(structuredModel, 0, structuredModel.getStructuredDocument().getLength());
            String string = structuredModel.getStructuredDocument().get();
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            return string;
        }
        catch (Throwable throwable) {
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            throw throwable;
        }
    }

    @Override
    public String cleanupContent(String input, int start, int length) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(input.getBytes("UTF8"));
            String id = String.valueOf(inputStream.toString()) + this.getContentType();
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(id, inputStream, null);
            this.cleanupModel(structuredModel, start, length);
            String string = structuredModel.getStructuredDocument().get();
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            return string;
        }
        catch (Throwable throwable) {
            this.ensureClosed(null, inputStream);
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
            throw throwable;
        }
    }

    @Override
    public void cleanupDocument(IDocument document) throws IOException, CoreException {
        if (document == null) {
            return;
        }
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
            this.cleanupModel(structuredModel);
            if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                structuredModel.save();
            }
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromEdit();
            }
        }
    }

    @Override
    public void cleanupDocument(IDocument document, int start, int length) throws IOException, CoreException {
        if (document == null) {
            return;
        }
        if (start >= 0 && length >= 0 && start + length <= document.getLength()) {
            IStructuredModel structuredModel = null;
            try {
                structuredModel = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
                this.cleanupModel(structuredModel, start, length);
                if (!structuredModel.isSharedForEdit() && structuredModel.isSaveNeeded()) {
                    structuredModel.save();
                }
            }
            finally {
                if (structuredModel != null) {
                    structuredModel.releaseFromEdit();
                }
            }
        }
    }

    @Override
    public void cleanupFile(IFile file) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(file);
            this.cleanupModel(structuredModel, 0, structuredModel.getStructuredDocument().getLength());
            structuredModel.save(file);
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    @Override
    public void cleanupFile(IFile file, int start, int length) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        try {
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(file);
            this.cleanupModel(structuredModel, start, length);
            structuredModel.save(file);
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    @Override
    public void cleanupFileName(String fileName) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(fileName, inputStream, null);
            this.cleanupModel(structuredModel, 0, structuredModel.getStructuredDocument().getLength());
            structuredModel.save();
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    @Override
    public void cleanupFileName(String fileName, int start, int length) throws IOException, CoreException {
        IStructuredModel structuredModel = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(fileName);
            structuredModel = StructuredModelManager.getModelManager().getModelForRead(fileName, inputStream, null);
            this.cleanupModel(structuredModel, start, length);
            structuredModel.save();
        }
        finally {
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
    }

    @Override
    public void cleanupModel(IStructuredModel structuredModel) {
        this.cleanupModel(structuredModel, null);
    }

    @Override
    public void cleanupModel(IStructuredModel structuredModel, int start, int length) {
        this.cleanupModel(structuredModel, start, length, null);
    }

    public void cleanupModel(IStructuredModel structuredModel, Object context) {
        int start = 0;
        int length = structuredModel.getStructuredDocument().getLength();
        this.cleanupModel(structuredModel, start, length, context);
    }

    public void cleanupModel(IStructuredModel structuredModel, int start, int length, Object context) {
        Vector activeNodes;
        if (structuredModel != null && start >= 0 && length <= structuredModel.getStructuredDocument().getLength() && (activeNodes = this.getActiveNodes(structuredModel, start, length)).size() > 0) {
            Node firstNode = (Node)activeNodes.firstElement();
            Node lastNode = (Node)activeNodes.lastElement();
            boolean done = false;
            Node eachNode = firstNode;
            Node nextNode = null;
            IDocumentExtension4 docExt4 = null;
            if (structuredModel.getStructuredDocument() instanceof IDocumentExtension4) {
                docExt4 = (IDocumentExtension4)structuredModel.getStructuredDocument();
            }
            DocumentRewriteSession rewriteSession = null;
            try {
                structuredModel.aboutToChangeModel();
                rewriteSession = docExt4 == null || docExt4.getActiveRewriteSession() != null ? null : docExt4.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                while (!done) {
                    done = eachNode == lastNode;
                    nextNode = eachNode.getNextSibling();
                    this.cleanupNode(eachNode);
                    eachNode = nextNode != null && nextNode.getParentNode() == null ? eachNode.getNextSibling() : nextNode;
                    if (eachNode != null) continue;
                    done = true;
                }
                if (this.getFormatSourcePreference(structuredModel)) {
                    IFormattingDelegate delegate = this.getFormattingDelegate();
                    if (context != null && delegate != null) {
                        delegate.format(context);
                    } else {
                        IStructuredFormatProcessor formatProcessor = this.getFormatProcessor();
                        formatProcessor.formatModel(structuredModel);
                    }
                }
            }
            finally {
                try {
                    if (docExt4 != null && rewriteSession != null) {
                        docExt4.stopRewriteSession(rewriteSession);
                    }
                }
                finally {
                    structuredModel.changedModel();
                }
            }
        }
    }

    @Override
    public void cleanupNode(Node node) {
        if (node != null) {
            IStructuredCleanupHandler cleanupHandler;
            Node cleanupNode = node;
            if (cleanupNode.getNodeType() == 2) {
                cleanupNode = ((Attr)cleanupNode).getOwnerElement();
            }
            if (this.refreshCleanupPreferences) {
                this.refreshCleanupPreferences();
            }
            if ((cleanupHandler = this.getCleanupHandler(cleanupNode)) != null) {
                cleanupHandler.cleanup(cleanupNode);
            }
        }
    }

    protected void convertLineDelimiters(IDocument document, String newDelimiter) {
        int lineCount = document.getNumberOfLines();
        Map partitioners = TextUtilities.removeDocumentPartitioners((IDocument)document);
        try {
            try {
                int i = 0;
                while (i < lineCount) {
                    String delimiter = document.getLineDelimiter(i);
                    if (delimiter != null && delimiter.length() > 0 && !delimiter.equals(newDelimiter)) {
                        IRegion region = document.getLineInformation(i);
                        document.replace(region.getOffset() + region.getLength(), delimiter.length(), newDelimiter);
                    }
                    ++i;
                }
            }
            catch (BadLocationException e) {
                Logger.logException(e);
                TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
            }
        }
        finally {
            TextUtilities.addDocumentPartitioners((IDocument)document, (Map)partitioners);
        }
    }

    protected void ensureClosed(OutputStream outputStream, InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    protected Vector getActiveNodes(IStructuredModel structuredModel, int startNodeOffset, int length) {
        Vector<Node> activeNodes = new Vector<Node>();
        if (structuredModel != null) {
            Node startNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset));
            Node endNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset + length));
            if (startNode != null) {
                while (!this.isSiblingOf(startNode, endNode)) {
                    if (endNode != null) {
                        endNode = endNode.getParentNode();
                    }
                    if (endNode != null) continue;
                    startNode = startNode.getParentNode();
                    endNode = (Node)((Object)structuredModel.getIndexedRegion(startNodeOffset + length));
                }
                while (startNode != endNode) {
                    activeNodes.addElement(startNode);
                    startNode = startNode.getNextSibling();
                }
                if (startNode != null) {
                    activeNodes.addElement(startNode);
                }
            }
        }
        return activeNodes;
    }

    protected abstract IStructuredCleanupHandler getCleanupHandler(Node var1);

    protected abstract String getContentType();

    protected boolean getConvertEOLCodesPreference(IStructuredModel structuredModel) {
        boolean convertEOLCodes = true;
        IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler((Node)((Object)structuredModel.getIndexedRegion(0)));
        if (cleanupHandler != null) {
            IStructuredCleanupPreferences cleanupPreferences = cleanupHandler.getCleanupPreferences();
            convertEOLCodes = cleanupPreferences.getConvertEOLCodes();
        }
        return convertEOLCodes;
    }

    protected String getEOLCodePreference(IStructuredModel structuredModel) {
        IScopeContext[] scopeContext = new IScopeContext[]{new InstanceScope()};
        String eolCode = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
        IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler((Node)((Object)structuredModel.getIndexedRegion(0)));
        if (cleanupHandler != null) {
            IStructuredCleanupPreferences cleanupPreferences = cleanupHandler.getCleanupPreferences();
            eolCode = cleanupPreferences.getEOLCode();
        }
        return eolCode;
    }

    protected abstract IStructuredFormatProcessor getFormatProcessor();

    protected boolean getFormatSourcePreference(IStructuredModel structuredModel) {
        boolean formatSource = true;
        IStructuredCleanupHandler cleanupHandler = this.getCleanupHandler((Node)((Object)structuredModel.getIndexedRegion(0)));
        if (cleanupHandler != null) {
            IStructuredCleanupPreferences cleanupPreferences = cleanupHandler.getCleanupPreferences();
            formatSource = cleanupPreferences.getFormatSource();
        }
        return formatSource;
    }

    protected boolean isSiblingOf(Node node, Node endNode) {
        if (endNode == null) {
            return true;
        }
        Node siblingNode = node;
        while (siblingNode != null) {
            if (siblingNode == endNode) {
                return true;
            }
            siblingNode = siblingNode.getNextSibling();
        }
        return false;
    }

    protected abstract void refreshCleanupPreferences();

    private synchronized IFormattingDelegate getFormattingDelegate() {
        IConfigurationElement[] element;
        if (delegate == null && (element = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.sse.core", "formattingDelegate")).length > 0) {
            try {
                Object d = element[0].createExecutableExtension("class");
                if (d instanceof IFormattingDelegate) {
                    delegate = (IFormattingDelegate)d;
                }
            }
            catch (CoreException e) {
                Logger.logException("Exception while creating the formatting delegate.", e);
            }
        }
        return delegate;
    }
}

