/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.ServerComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.HostnameComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.NewDetectServerComposite;
import org.eclipse.wst.server.ui.internal.wizard.page.NewManualServerComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class NewServerComposite
extends Composite {
    protected IWizardHandle wizard;
    protected TaskModel taskModel;
    protected IModule module;
    protected IModuleType moduleType;
    protected String serverTypeId;
    protected String launchMode;
    protected static final byte MODE_EXISTING = 0;
    protected static final byte MODE_DETECT = 1;
    protected static final byte MODE_MANUAL = 2;
    protected byte mode;
    protected Composite detectComp2;
    protected NewDetectServerComposite detectComp;
    protected HostnameComposite detectHostComp;
    protected Composite manualComp2;
    protected NewManualServerComposite manualComp;
    protected HostnameComposite manualHostComp;
    protected ServerComposite existingComp;
    protected Composite stack;
    protected StackLayout stackLayout;
    protected String lastHostname;
    protected IServerWorkingCopy existingWC;

    public NewServerComposite(Composite parent, IWizardHandle wizard, IModuleType moduleType, String serverTypeId, String launchMode) {
        super(parent, 0);
        this.wizard = wizard;
        this.moduleType = moduleType;
        this.serverTypeId = serverTypeId;
        this.launchMode = launchMode;
        wizard.setTitle(Messages.wizNewServerTitle);
        wizard.setDescription(Messages.wizNewServerDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("newServerWiz"));
        this.createControl();
    }

    public NewServerComposite(Composite parent, IWizardHandle wizard, IModule module, String launchMode) {
        super(parent, 0);
        this.wizard = wizard;
        this.module = module;
        this.launchMode = launchMode;
        wizard.setTitle(Messages.wizNewServerTitle);
        wizard.setDescription(Messages.wizNewServerDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("newServerWiz"));
        this.createControl();
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 64);
        label.setText(text);
        GridData data = new GridData(258);
        data.horizontalSpan = span;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 1);
    }

    protected Button createRadioButton(Composite parent, String text, int span) {
        Button button = new Button(parent, 16);
        button.setText(text);
        GridData data = new GridData(258);
        data.horizontalSpan = span;
        data.horizontalIndent = 10;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Text createText(Composite parent, String text2, int span) {
        Text text = new Text(parent, 0);
        text.setText(text2);
        GridData data = new GridData(258);
        data.horizontalSpan = span;
        text.setLayoutData((Object)data);
        return text;
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swns0000");
        if (this.module != null) {
            if ("debug".equals(this.launchMode)) {
                this.wizard.setTitle(Messages.wizDebugOnServerTitle);
            } else if ("profile".equals(this.launchMode)) {
                this.wizard.setTitle(Messages.wizProfileOnServerTitle);
            } else {
                this.wizard.setTitle(Messages.wizRunOnServerTitle);
            }
            this.wizard.setDescription(Messages.wizNewServerRunOnServerDescription);
            this.createLabel(this, Messages.wizNewServerSelect, 1);
        }
        Button existing = null;
        if (this.module != null) {
            final Button predefined = this.createRadioButton(this, Messages.wizNewServerExisting, 1);
            predefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (predefined.getSelection()) {
                        NewServerComposite.this.toggleMode((byte)0);
                    }
                }
            });
            existing = predefined;
        }
        Button manual = null;
        if (this.module != null) {
            final Button manualButton = this.createRadioButton(this, Messages.wizNewServerManual, 1);
            manualButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (manualButton.getSelection()) {
                        NewServerComposite.this.toggleMode((byte)2);
                    }
                }
            });
            manual = manualButton;
        }
        this.stack = new Composite((Composite)this, 0);
        GridData data = new GridData(1808);
        this.stack.setLayoutData((Object)data);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.stack.setLayout((Layout)this.stackLayout);
        if (this.module != null) {
            this.createExistingComposite(this.stack);
        }
        this.createAutoComposite(this.stack);
        this.createManualComposite(this.stack);
        if (this.existingComp != null && existing != null) {
            if (this.isExistingServer()) {
                this.mode = 0;
                this.stackLayout.topControl = this.existingComp;
                existing.setSelection(true);
            } else {
                this.mode = (byte)2;
                this.stackLayout.topControl = this.manualComp2;
                this.manualComp.setVisible(true);
                if (manual != null) {
                    manual.setSelection(true);
                }
                existing.setEnabled(false);
                this.existingComp.setEnabled(false);
            }
        } else {
            this.mode = (byte)2;
            this.stackLayout.topControl = this.manualComp2;
            this.manualComp.setVisible(true);
            if (manual != null) {
                manual.setSelection(true);
            }
        }
        if (this.module != null) {
            final Button pref = new Button((Composite)this, 96);
            pref.setText(Messages.wizSelectServerPreferred);
            data = new GridData(264);
            pref.setLayoutData((Object)data);
            pref.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewServerComposite.this.taskModel.putObject("defaultServer", (Object)new Boolean(pref.getSelection()));
                }
            });
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pref, "org.eclipse.wst.server.ui.swsi0014");
        }
        Dialog.applyDialogFont((Control)this);
    }

    protected void toggleMode(byte newMode) {
        if (!this.isVisible()) {
            return;
        }
        if (newMode == this.mode) {
            return;
        }
        this.mode = newMode;
        this.wizard.setMessage(null, 0);
        if (this.mode == 0) {
            this.stackLayout.topControl = this.existingComp;
            this.existingComp.setSelection(this.existingComp.getSelectedServer());
        } else if (this.mode == 1) {
            this.stackLayout.topControl = this.detectComp2;
            this.detectComp.setVisible(true);
        } else {
            this.stackLayout.topControl = this.manualComp2;
            this.manualComp.setVisible(true);
        }
        this.stack.layout();
        if (this.taskModel != null) {
            this.taskModel.putObject("mode", (Object)new Byte(this.mode));
            this.updateTaskModel();
        }
    }

    protected HostnameComposite createHostComposite(Composite comp) {
        HostnameComposite hostComp = new HostnameComposite(comp, new HostnameComposite.IHostnameSelectionListener(){

            @Override
            public void hostnameSelected(String host) {
                NewServerComposite.this.lastHostname = host;
                if (NewServerComposite.this.detectComp != null) {
                    NewServerComposite.this.detectComp.setHost(host);
                }
                if (NewServerComposite.this.manualComp != null) {
                    NewServerComposite.this.manualComp.setHost(host);
                }
            }
        });
        if (this.lastHostname != null) {
            hostComp.setHostname(this.lastHostname);
        }
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        hostComp.setLayoutData(data);
        return hostComp;
    }

    protected void createAutoComposite(Composite comp) {
        this.detectComp2 = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.detectComp2.setLayout((Layout)layout);
        this.detectHostComp = this.createHostComposite(this.detectComp2);
        this.detectComp = new NewDetectServerComposite(this.detectComp2, new NewDetectServerComposite.IServerSelectionListener(){

            @Override
            public void serverSelected(IServerAttributes server) {
            }
        });
        if (this.lastHostname != null) {
            this.detectComp.setHost(this.lastHostname);
        } else {
            this.detectComp.setHost("localhost");
        }
        GridData data = new GridData(784);
        data.horizontalSpan = 3;
        data.heightHint = 150;
        this.detectComp.setLayoutData(data);
    }

    protected void createExistingComposite(Composite comp) {
        this.existingComp = new ServerComposite(comp, new ServerComposite.ServerSelectionListener(){

            @Override
            public void serverSelected(IServer server) {
                IStatus status;
                NewServerComposite.this.wizard.setMessage(null, 0);
                if (server != null && NewServerComposite.this.module != null && (status = NewServerComposite.isSupportedModule((IServerAttributes)server, NewServerComposite.this.module)) != null) {
                    if (status.getSeverity() == 4) {
                        NewServerComposite.this.wizard.setMessage(status.getMessage(), 3);
                        server = null;
                    } else if (status.getSeverity() == 2) {
                        NewServerComposite.this.wizard.setMessage(status.getMessage(), 2);
                    } else if (status.getSeverity() == 1) {
                        NewServerComposite.this.wizard.setMessage(status.getMessage(), 1);
                    }
                }
                if (NewServerComposite.this.existingWC != null) {
                    if (server != null && server.equals(NewServerComposite.this.existingWC.getOriginal())) {
                        return;
                    }
                    NewServerComposite.this.existingWC = null;
                }
                if (server != null) {
                    NewServerComposite.this.existingWC = server.createWorkingCopy();
                }
                NewServerComposite.this.updateTaskModel();
            }
        }, this.module, this.launchMode);
        this.existingComp.setIncludeIncompatibleVersions(true);
        GridData data = new GridData(784);
        data.horizontalSpan = 3;
        data.heightHint = 150;
        this.existingComp.setLayoutData(data);
    }

    protected static IStatus isSupportedModule(IServerAttributes server, IModule module) {
        if (server != null && module != null) {
            IModule[] rootModules;
            block13: {
                IServerType serverType = server.getServerType();
                IModuleType mt = module.getModuleType();
                if (!ServerUtil.isSupportedModule((IModuleType[])serverType.getRuntimeType().getModuleTypes(), (IModuleType)mt)) {
                    String type = mt.getName();
                    return new Status(4, "org.eclipse.wst.server.ui", NLS.bind((String)Messages.errorVersionLevel, (Object[])new Object[]{type, mt.getVersion()}));
                }
                rootModules = null;
                try {
                    rootModules = server.getRootModules(module, null);
                }
                catch (CoreException ce) {
                    return ce.getStatus();
                }
                catch (Exception e) {
                    if (!Trace.WARNING) break block13;
                    Trace.trace("/warning", "Could not find root module", e);
                }
            }
            if (rootModules != null) {
                if (rootModules.length == 0) {
                    return new Status(4, "org.eclipse.wst.server.ui", Messages.errorRootModule);
                }
                int size = rootModules.length;
                IStatus status = null;
                boolean found = false;
                int i = 0;
                while (i < size) {
                    block14: {
                        try {
                            if (server != null) {
                                status = server.canModifyModules(new IModule[]{rootModules[i]}, null, null);
                            }
                            if (status != null && status.isOK()) {
                                found = true;
                            }
                        }
                        catch (Exception e) {
                            if (!Trace.WARNING) break block14;
                            Trace.trace("/warning", "Could not find root module", e);
                        }
                    }
                    ++i;
                }
                if (!found && status != null) {
                    return status;
                }
            }
        }
        return null;
    }

    protected boolean isExistingServer() {
        if (this.module == null || this.launchMode == null) {
            return false;
        }
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                IModuleType mt = this.module.getModuleType();
                if (ServerUIPlugin.isCompatibleWithLaunchMode(servers[i], this.launchMode) && ServerUtil.isSupportedModule((IModuleType[])servers[i].getServerType().getRuntimeType().getModuleTypes(), (IModuleType)mt)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void createManualComposite(Composite comp) {
        this.manualComp2 = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        this.manualComp2.setLayout((Layout)layout);
        this.manualComp2.setLayoutData((Object)new GridData(1808));
        IModuleType mt = this.moduleType;
        boolean includeIncompatible = true;
        if (this.moduleType != null) {
            includeIncompatible = false;
        }
        if (this.module != null) {
            mt = this.module.getModuleType();
        }
        this.manualComp = new NewManualServerComposite(this.manualComp2, new NewManualServerComposite.IWizardHandle2(){

            @Override
            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InterruptedException, InvocationTargetException {
                NewServerComposite.this.wizard.run(fork, cancelable, runnable);
            }

            @Override
            public void update() {
                NewServerComposite.this.wizard.update();
            }

            @Override
            public void setMessage(String newMessage, int newType) {
                NewServerComposite.this.wizard.setMessage(newMessage, newType);
            }
        }, mt, this.module, this.serverTypeId, includeIncompatible, new NewManualServerComposite.ServerSelectionListener(){

            @Override
            public void serverSelected(IServerAttributes server) {
                NewServerComposite.this.updateTaskModel();
            }

            @Override
            public void runtimeSelected(IRuntime runtime) {
                NewServerComposite.this.updateTaskModel();
            }
        });
        if (this.lastHostname != null) {
            this.manualComp.setHost(this.lastHostname);
        } else {
            this.manualComp.setHost("localhost");
        }
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.heightHint = 360;
        this.manualComp.setLayoutData(data);
    }

    public NewManualServerComposite getNewManualServerComposite() {
        return this.manualComp;
    }

    protected void updateTaskModel() {
        if (this.taskModel != null) {
            IServerWorkingCopy server = this.getServer();
            if (server != null) {
                this.taskModel.putObject("server", (Object)server);
                this.taskModel.putObject("runtime", (Object)server.getRuntime());
            } else {
                this.taskModel.putObject("server", null);
                this.taskModel.putObject("runtime", null);
            }
        }
        this.wizard.update();
    }

    public void setTaskModel(TaskModel model) {
        this.taskModel = model;
        this.taskModel.putObject("mode", (Object)new Byte(this.mode));
        this.updateTaskModel();
    }

    public IServerWorkingCopy getServer() {
        if (this.mode == 0) {
            return this.existingWC;
        }
        if (this.mode == 1) {
            return this.detectComp.getServer();
        }
        return this.manualComp.getServer();
    }

    public IRuntime getRuntime() {
        if (this.mode == 0) {
            IServer server = this.existingComp.getSelectedServer();
            if (server != null) {
                return server.getRuntime();
            }
            return null;
        }
        if (this.mode == 1) {
            return null;
        }
        return this.manualComp.getRuntime();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Control[] c = this.getChildren();
        if (c != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
    }
}

