/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.sse.ui.typing.AbstractCharacterPairInserter;

public class JsCharacterPairInserter
extends AbstractCharacterPairInserter
implements IPropertyChangeListener {
    private boolean fCloseStrings;
    private boolean fCloseBrackets;
    private boolean fCloseBraces;
    private boolean fCloseAngularBrackets;

    public boolean hasPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '(': 
            case '<': 
            case '[': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean shouldPair(ISourceViewer viewer, char c) {
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
            int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            switch (c) {
                case '(': {
                    if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) return true;
                    return false;
                }
                case '<': {
                    if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) return true;
                    return false;
                }
                case '{': {
                    if (this.fCloseBraces && nextToken != 2000 && (next == null || next.length() <= 1)) return true;
                    return false;
                }
                case '[': {
                    if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) return true;
                    return false;
                }
                case '\"': 
                case '\'': {
                    if (this.fCloseStrings && nextToken != 2000 && prevToken != 2000 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1)) return true;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected char getPair(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '<': {
                return '>';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '\'': {
                return c;
            }
            case '\"': {
                return c;
            }
        }
        throw new IllegalArgumentException();
    }

    public void initialize() {
        super.initialize();
        IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
        this.fCloseStrings = preferenceStore.getBoolean("closeStrings");
        this.fCloseBrackets = preferenceStore.getBoolean("closeBrackets");
        this.fCloseBraces = preferenceStore.getBoolean("closeBraces");
        this.fCloseAngularBrackets = "1.5".compareTo(preferenceStore.getString("org.eclipse.wst.jsdt.core.compiler.source")) <= 0;
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        JavaScriptPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("closeStrings".equals(event.getProperty())) {
            this.fCloseStrings = (Boolean)event.getNewValue();
        } else if ("closeBrackets".equals(event.getProperty())) {
            this.fCloseBrackets = (Boolean)event.getNewValue();
        } else if ("closeBraces".equals(event.getProperty())) {
            this.fCloseBraces = (Boolean)event.getNewValue();
        } else if ("org.eclipse.wst.jsdt.core.compiler.source".equals(event.getProperty())) {
            IPreferenceStore preferenceStore = JavaScriptPlugin.getDefault().getPreferenceStore();
            this.fCloseAngularBrackets = "1.5".compareTo(preferenceStore.getString("org.eclipse.wst.jsdt.core.compiler.source")) <= 0;
        }
    }

    private boolean isAngularIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }

    protected LinkedModeUI.IExitPolicy getExitPolicy(char exit, char escape, IDocument document) {
        return new ExitPolicy(exit, escape, document);
    }

    private static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private char fExit;
        private char fEscape;
        private IDocument fDocument;

        public ExitPolicy(char exit, char escape, IDocument document) {
            this.fExit = exit;
            this.fEscape = escape;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (!this.isMasked(offset)) {
                if (event.character == this.fExit) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                if (event.character == '\r' && offset > 0) {
                    try {
                        if (this.fDocument.getChar(offset - 1) == '{') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.logException("Error while trying to exit linked mode", e);
                    }
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            try {
                return this.fEscape == this.fDocument.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

