/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyFiltersActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CancelSearchAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CopyCallHierarchyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.FocusOnSelectionAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.HistoryDropDownAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.ICallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationCopyAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.LocationViewer;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.OpenLocationAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.RefreshAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.ToggleCallModeAction;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.ToggleOrientationAction;
import org.eclipse.wst.jsdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;
import org.eclipse.wst.jsdt.ui.actions.CCPActionGroup;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.wst.jsdt.ui.actions.OpenViewActionGroup;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

public class CallHierarchyViewPart
extends ViewPart
implements ICallHierarchyViewPart,
ISelectionChangedListener {
    private static final String DIALOGSTORE_VIEWORIENTATION = "CallHierarchyViewPart.orientation";
    private static final String DIALOGSTORE_CALL_MODE = "CallHierarchyViewPart.call_mode";
    private static final String DIALOGSTORE_RATIO = "CallHierarchyViewPart.ratio";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_SINGLE = 2;
    static final int VIEW_ORIENTATION_AUTOMATIC = 3;
    static final int CALL_MODE_CALLERS = 0;
    static final int CALL_MODE_CALLEES = 1;
    static final String GROUP_SEARCH_SCOPE = "MENU_SEARCH_SCOPE";
    static final String ID_CALL_HIERARCHY = "org.eclipse.wst.jsdt.callhierarchy.view";
    private static final String GROUP_FOCUS = "group.focus";
    private static final int PAGE_EMPTY = 0;
    private static final int PAGE_VIEWER = 1;
    private Label fNoHierarchyShownLabel;
    private PageBook fPagebook;
    private IDialogSettings fDialogSettings = JavaScriptPlugin.getDefault().getDialogSettings();
    private int fCurrentOrientation;
    int fOrientation = 3;
    private int fCurrentCallMode;
    private MethodWrapper fCalleeRoot;
    private MethodWrapper fCallerRoot;
    private IMemento fMemento;
    private IFunction fShownMethod;
    private CallHierarchySelectionProvider fSelectionProviderMediator;
    private List fMethodHistory = new ArrayList();
    private LocationViewer fLocationViewer;
    private SashForm fHierarchyLocationSplitter;
    private Clipboard fClipboard;
    private SearchScopeActionGroup fSearchScopeActions;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ToggleCallModeAction[] fToggleCallModeActions;
    private CallHierarchyFiltersActionGroup fFiltersActionGroup;
    private HistoryDropDownAction fHistoryDropDownAction;
    private RefreshAction fRefreshAction;
    private OpenLocationAction fOpenLocationAction;
    private LocationCopyAction fLocationCopyAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private CopyCallHierarchyAction fCopyAction;
    private CancelSearchAction fCancelSearchAction;
    private CompositeActionGroup fActionGroups;
    private CallHierarchyViewer fCallHierarchyViewer;
    private boolean fShowCallDetails;
    protected Composite fParent;
    private IPartListener2 fPartListener;

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setHistoryEntries(IFunction[] elems) {
        this.fMethodHistory.clear();
        int i = 0;
        while (i < elems.length) {
            this.fMethodHistory.add(elems[i]);
            ++i;
        }
        this.updateHistoryEntries();
    }

    public IFunction[] getHistoryEntries() {
        if (this.fMethodHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fMethodHistory.toArray(new IFunction[this.fMethodHistory.size()]);
    }

    public void setMethod(IFunction method) {
        if (method == null) {
            this.showPage(0);
            return;
        }
        if (!method.equals(this.fShownMethod)) {
            this.addHistoryEntry((IJavaScriptElement)method);
        }
        this.fShownMethod = method;
        this.refresh();
    }

    public IFunction getMethod() {
        return this.fShownMethod;
    }

    public MethodWrapper getCurrentMethodWrapper() {
        if (this.fCurrentCallMode == 0) {
            return this.fCallerRoot;
        }
        return this.fCalleeRoot;
    }

    void setOrientation(int orientation) {
        if (this.fCurrentOrientation != orientation) {
            if (this.fLocationViewer != null && !this.fLocationViewer.getControl().isDisposed() && this.fHierarchyLocationSplitter != null && !this.fHierarchyLocationSplitter.isDisposed()) {
                if (orientation == 2) {
                    this.setShowCallDetails(false);
                } else {
                    if (this.fCurrentOrientation == 2) {
                        this.setShowCallDetails(true);
                    }
                    boolean horizontal = orientation == 1;
                    this.fHierarchyLocationSplitter.setOrientation(horizontal ? 256 : 512);
                }
                this.fHierarchyLocationSplitter.layout();
            }
            this.updateCheckedState();
            this.fCurrentOrientation = orientation;
            this.restoreSplitterRatio();
        }
    }

    private void updateCheckedState() {
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
    }

    void setCallMode(int mode) {
        if (this.fCurrentCallMode != mode) {
            int i = 0;
            while (i < this.fToggleCallModeActions.length) {
                this.fToggleCallModeActions[i].setChecked(mode == this.fToggleCallModeActions[i].getMode());
                ++i;
            }
            this.fCurrentCallMode = mode;
            this.fDialogSettings.put(DIALOGSTORE_CALL_MODE, mode);
            this.updateView();
        }
    }

    public IJavaScriptSearchScope getSearchScope() {
        return this.fSearchScopeActions.getSearchScope();
    }

    public void setShowCallDetails(boolean show) {
        this.fShowCallDetails = show;
        this.showOrHideCallDetailsView();
    }

    private void initDragAndDrop() {
        this.addDragAdapters((StructuredViewer)this.fCallHierarchyViewer);
        this.addDropAdapters((StructuredViewer)this.fCallHierarchyViewer);
        this.addDropAdapters((StructuredViewer)this.fLocationViewer);
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        dropTarget.addDropListener((DropTargetListener)new CallHierarchyTransferDropAdapter(this, (StructuredViewer)this.fCallHierarchyViewer));
    }

    private void addDropAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        int ops = 23;
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new CallHierarchyTransferDropAdapter(this, viewer)};
        viewer.addDropSupport(ops, transfers, (DropTargetListener)new DelegatingDropAdapter(dropListeners));
    }

    private void addDragAdapters(StructuredViewer viewer) {
        int ops = 5;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)viewer), new ResourceTransferDragAdapter((ISelectionProvider)viewer)};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new JdtViewerDragAdapter(viewer, dragListeners));
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fPagebook = new PageBook(parent, 0);
        this.createHierarchyLocationSplitter((Composite)this.fPagebook);
        this.createCallHierarchyViewer((Composite)this.fHierarchyLocationSplitter);
        this.createLocationViewer((Composite)this.fHierarchyLocationSplitter);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(CallHierarchyMessages.CallHierarchyViewPart_empty);
        this.initDragAndDrop();
        this.showPage(0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.eclipse.wst.jsdt.ui.call_hierarchy_view_context");
        this.fSelectionProviderMediator = new CallHierarchySelectionProvider(new StructuredViewer[]{this.fCallHierarchyViewer, this.fLocationViewer});
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fSelectionProviderMediator.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProviderMediator);
        this.fCallHierarchyViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                CallHierarchyViewPart.this.fillCallHierarchyViewerContextMenu(menu);
            }
        }, this.getSite(), (ISelectionProvider)this.fSelectionProviderMediator);
        this.fClipboard = new Clipboard(parent.getDisplay());
        this.makeActions();
        this.fillViewMenu();
        this.fillActionBars();
        this.initOrientation();
        this.initCallMode();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.restoreSplitterRatio();
        this.addPartListener();
    }

    private void restoreSplitterRatio() {
        String ratio = this.fDialogSettings.get(DIALOGSTORE_RATIO + this.fCurrentOrientation);
        if (ratio == null) {
            return;
        }
        int intRatio = Integer.parseInt(ratio);
        this.fHierarchyLocationSplitter.setWeights(new int[]{intRatio, 1000 - intRatio});
    }

    private void saveSplitterRatio() {
        if (this.fHierarchyLocationSplitter != null && !this.fHierarchyLocationSplitter.isDisposed()) {
            int[] weigths = this.fHierarchyLocationSplitter.getWeights();
            int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
            String key = DIALOGSTORE_RATIO + this.fCurrentOrientation;
            this.fDialogSettings.put(key, ratio);
        }
    }

    private void addPartListener() {
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (CallHierarchyViewPart.ID_CALL_HIERARCHY.equals(partRef.getId())) {
                    CallHierarchyViewPart.this.saveViewSettings();
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
                if (CallHierarchyViewPart.ID_CALL_HIERARCHY.equals(partRef.getId())) {
                    CallHierarchyViewPart.this.saveViewSettings();
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
    }

    protected void saveViewSettings() {
        this.saveSplitterRatio();
        this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, this.fOrientation);
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                CallHierarchyViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        this.saveSplitterRatio();
        this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, this.fOrientation);
        if (this.fOrientation != 3) {
            this.setOrientation(this.fOrientation);
        } else {
            if (this.fOrientation == 2) {
                return;
            }
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void showPage(int page) {
        if (page == 0) {
            this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        } else {
            this.fPagebook.showPage((Control)this.fHierarchyLocationSplitter);
        }
    }

    private void restoreState(IMemento memento) {
        this.fSearchScopeActions.restoreState(memento);
    }

    private void initCallMode() {
        int mode;
        try {
            mode = this.fDialogSettings.getInt(DIALOGSTORE_CALL_MODE);
            if (mode < 0 || mode > 1) {
                mode = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            mode = 0;
        }
        this.fCurrentCallMode = -1;
        this.setCallMode(mode);
    }

    private void initOrientation() {
        try {
            this.fOrientation = this.fDialogSettings.getInt(DIALOGSTORE_VIEWORIENTATION);
            if (this.fOrientation < 0 || this.fOrientation > 3) {
                this.fOrientation = 3;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrientation = 3;
        }
        this.fCurrentOrientation = -1;
        this.setOrientation(this.fOrientation);
    }

    private void fillViewMenu() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        viewMenu.add((IContributionItem)new Separator());
        int i = 0;
        while (i < this.fToggleCallModeActions.length) {
            viewMenu.add((IAction)this.fToggleCallModeActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(CallHierarchyMessages.CallHierarchyViewPart_layout_menu);
        int i2 = 0;
        while (i2 < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i2]);
            ++i2;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
    }

    public void dispose() {
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fPartListener != null) {
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fPartListener = null;
        }
        super.dispose();
    }

    public void gotoHistoryEntry(IFunction entry) {
        if (this.fMethodHistory.contains(entry)) {
            this.setMethod(entry);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void refresh() {
        this.setCalleeRoot(null);
        this.setCallerRoot(null);
        this.updateView();
    }

    public void saveState(IMemento memento) {
        if (this.fPagebook == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        this.fSearchScopeActions.saveState(memento);
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelectionProvider() == this.fCallHierarchyViewer) {
            this.methodSelectionChanged(e.getSelection());
        }
    }

    private void methodSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
            if (selectedElement instanceof MethodWrapper) {
                MethodWrapper methodWrapper = (MethodWrapper)((Object)selectedElement);
                this.revealElementInEditor((Object)methodWrapper, (Viewer)this.fCallHierarchyViewer);
                this.updateLocationsView(methodWrapper);
            } else {
                this.updateLocationsView(null);
            }
        } else {
            this.updateLocationsView(null);
        }
    }

    private void revealElementInEditor(Object elem, Viewer originViewer) {
        IEditorPart editorPart;
        if (this.getSite().getPage().getActivePart() != this) {
            return;
        }
        if (this.fSelectionProviderMediator.getViewerInFocus() != originViewer) {
            return;
        }
        if (elem instanceof MethodWrapper) {
            CallLocation callLocation = CallHierarchy.getCallLocation(elem);
            if (callLocation != null) {
                IEditorPart editorPart2 = CallHierarchyUI.isOpenInEditor(callLocation);
                if (editorPart2 != null) {
                    this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart2);
                    if (editorPart2 instanceof ITextEditor) {
                        ITextEditor editor = (ITextEditor)editorPart2;
                        editor.selectAndReveal(callLocation.getStart(), callLocation.getEnd() - callLocation.getStart());
                    }
                }
            } else {
                IEditorPart editorPart3 = CallHierarchyUI.isOpenInEditor(elem);
                this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart3);
                EditorUtility.revealInEditor(editorPart3, (IJavaScriptElement)((MethodWrapper)((Object)elem)).getMember());
            }
        } else if (elem instanceof IJavaScriptElement && (editorPart = EditorUtility.isOpenInEditor(elem)) != null) {
            this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart);
            EditorUtility.revealInEditor(editorPart, (IJavaScriptElement)elem);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContextProvider.class) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_view_context");
        }
        if (adapter == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(adapter);
    }

    protected ISelection getSelection() {
        StructuredViewer viewerInFocus = this.fSelectionProviderMediator.getViewerInFocus();
        if (viewerInFocus != null) {
            return viewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    protected void fillLocationViewerContextMenu(IMenuManager menu) {
        JavaScriptPlugin.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IAction)this.fOpenLocationAction);
        menu.appendToGroup("group.show", (IAction)this.fRefreshAction);
        menu.appendToGroup("group.reorganize", (IAction)this.fLocationCopyAction);
    }

    protected void handleKeyEvent(KeyEvent event) {
        if (event.stateMask == 0 && event.keyCode == 0x100000E && this.fRefreshAction != null && this.fRefreshAction.isEnabled()) {
            this.fRefreshAction.run();
            return;
        }
    }

    private IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    private void setCalleeRoot(MethodWrapper calleeRoot) {
        this.fCalleeRoot = calleeRoot;
    }

    private MethodWrapper getCalleeRoot() {
        if (this.fCalleeRoot == null) {
            this.fCalleeRoot = CallHierarchy.getDefault().getCalleeRoot(this.fShownMethod);
        }
        return this.fCalleeRoot;
    }

    private void setCallerRoot(MethodWrapper callerRoot) {
        this.fCallerRoot = callerRoot;
    }

    private MethodWrapper getCallerRoot() {
        if (this.fCallerRoot == null) {
            this.fCallerRoot = CallHierarchy.getDefault().getCallerRoot(this.fShownMethod);
        }
        return this.fCallerRoot;
    }

    private void addHistoryEntry(IJavaScriptElement entry) {
        if (this.fMethodHistory.contains(entry)) {
            this.fMethodHistory.remove(entry);
        }
        this.fMethodHistory.add(0, entry);
        this.fHistoryDropDownAction.setEnabled(!this.fMethodHistory.isEmpty());
    }

    private void createLocationViewer(Composite parent) {
        this.fLocationViewer = new LocationViewer(parent);
        this.fLocationViewer.getControl().addKeyListener(this.createKeyListener());
        this.fLocationViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                CallHierarchyViewPart.this.fillLocationViewerContextMenu(menu);
            }
        }, ID_CALL_HIERARCHY, this.getSite());
    }

    private void createHierarchyLocationSplitter(Composite parent) {
        this.fHierarchyLocationSplitter = new SashForm(parent, 0);
        this.fHierarchyLocationSplitter.addKeyListener(this.createKeyListener());
    }

    private void createCallHierarchyViewer(Composite parent) {
        this.fCallHierarchyViewer = new CallHierarchyViewer(parent, this);
        this.fCallHierarchyViewer.addKeyListener(this.createKeyListener());
        this.fCallHierarchyViewer.addSelectionChangedListener(this);
    }

    protected void fillCallHierarchyViewerContextMenu(IMenuManager menu) {
        JavaScriptPlugin.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IAction)this.fRefreshAction);
        menu.appendToGroup("group.show", (IContributionItem)new Separator(GROUP_FOCUS));
        if (this.fFocusOnSelectionAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnSelectionAction);
        }
        if (this.fCopyAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fCopyAction);
        }
        this.fActionGroups.setContext(new ActionContext(this.getSelection()));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fActionGroups.fillActionBars(actionBars);
        toolBar.add((IAction)this.fCancelSearchAction);
        int i = 0;
        while (i < this.fToggleCallModeActions.length) {
            toolBar.add((IAction)this.fToggleCallModeActions[i]);
            ++i;
        }
        toolBar.add((IAction)this.fHistoryDropDownAction);
    }

    private KeyListener createKeyListener() {
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                CallHierarchyViewPart.this.handleKeyEvent(event);
            }
        };
        return keyListener;
    }

    private void makeActions() {
        this.fRefreshAction = new RefreshAction(this);
        this.fOpenLocationAction = new OpenLocationAction(this, (IWorkbenchSite)this.getSite());
        this.fLocationViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CallHierarchyViewPart.this.fOpenLocationAction.run();
            }
        });
        this.fLocationCopyAction = this.fLocationViewer.initCopyAction(this.getViewSite(), this.fClipboard);
        this.fFocusOnSelectionAction = new FocusOnSelectionAction(this);
        this.fCopyAction = new CopyCallHierarchyAction(this, this.fClipboard, this.fCallHierarchyViewer);
        this.fSearchScopeActions = new SearchScopeActionGroup(this, this.fDialogSettings);
        this.fFiltersActionGroup = new CallHierarchyFiltersActionGroup((IViewPart)this, (StructuredViewer)this.fCallHierarchyViewer);
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(false);
        this.fCancelSearchAction = new CancelSearchAction(this);
        this.setCancelEnabled(false);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 3), new ToggleOrientationAction(this, 2)};
        this.fToggleCallModeActions = new ToggleCallModeAction[]{new ToggleCallModeAction(this, 0), new ToggleCallModeAction(this, 1)};
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenEditorActionGroup((IViewPart)this), new OpenViewActionGroup((IViewPart)this), new CCPActionGroup((IViewPart)this), new GenerateActionGroup((IViewPart)this), new RefactorActionGroup((IViewPart)this), new JavaSearchActionGroup((IViewPart)this), this.fSearchScopeActions, this.fFiltersActionGroup});
    }

    private void showOrHideCallDetailsView() {
        if (this.fShowCallDetails) {
            this.fHierarchyLocationSplitter.setMaximizedControl(null);
        } else {
            this.fHierarchyLocationSplitter.setMaximizedControl(this.fCallHierarchyViewer.getControl());
        }
    }

    private void updateLocationsView(MethodWrapper methodWrapper) {
        if (methodWrapper != null && methodWrapper.getMethodCall().hasCallLocations()) {
            this.fLocationViewer.setInput(methodWrapper.getMethodCall().getCallLocations());
        } else {
            this.fLocationViewer.clearViewer();
        }
    }

    private void updateHistoryEntries() {
        int i = this.fMethodHistory.size() - 1;
        while (i >= 0) {
            IFunction method = (IFunction)this.fMethodHistory.get(i);
            if (!method.exists()) {
                this.fMethodHistory.remove(i);
            }
            --i;
        }
        this.fHistoryDropDownAction.setEnabled(!this.fMethodHistory.isEmpty());
    }

    private void updateView() {
        if (this.fShownMethod != null) {
            this.showPage(1);
            CallHierarchy.getDefault().setSearchScope(this.getSearchScope());
            String elementName = JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fShownMethod, 0x20000AL);
            String scopeDescription = this.fSearchScopeActions.getFullDescription();
            Object[] args = new String[]{elementName, scopeDescription};
            this.fCallHierarchyViewer.setInput(null);
            if (this.fCurrentCallMode == 0) {
                this.setContentDescription(Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsToMethod, args));
                this.fCallHierarchyViewer.setComparator(new ViewerComparator());
                this.fCallHierarchyViewer.setMethodWrapper(this.getCallerRoot());
            } else {
                this.setContentDescription(Messages.format(CallHierarchyMessages.CallHierarchyViewPart_callsFromMethod, args));
                this.fCallHierarchyViewer.setComparator(null);
                this.fCallHierarchyViewer.setMethodWrapper(this.getCalleeRoot());
            }
        }
    }

    static CallHierarchyViewPart findAndShowCallersView(IWorkbenchPartSite site) {
        IWorkbenchPage workbenchPage = site.getPage();
        CallHierarchyViewPart callersView = null;
        try {
            callersView = (CallHierarchyViewPart)workbenchPage.showView(ID_CALL_HIERARCHY);
        }
        catch (PartInitException e) {
            JavaScriptPlugin.log(e);
        }
        return callersView;
    }

    void cancelJobs() {
        this.fCallHierarchyViewer.cancelJobs();
    }

    void setCancelEnabled(boolean enabled) {
        this.fCancelSearchAction.setEnabled(enabled);
    }

    private class CallHierarchySelectionProvider
    extends SelectionProviderMediator {
        public CallHierarchySelectionProvider(StructuredViewer[] viewers) {
            super(viewers, null);
        }

        @Override
        public ISelection getSelection() {
            ISelection selection = super.getSelection();
            if (!selection.isEmpty()) {
                return CallHierarchyUI.convertSelection(selection);
            }
            return selection;
        }
    }
}

