/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;

public class SurroundWithTryCatchRefactoring
extends Refactoring {
    private Selection fSelection;
    private ISurroundWithTryCatchQuery fQuery;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fLeaveDirty;
    private IJavaScriptUnit fCUnit;
    private JavaScriptUnit fRootNode;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode[] fSelectedNodes;

    private SurroundWithTryCatchRefactoring(IJavaScriptUnit cu, Selection selection, ISurroundWithTryCatchQuery query) {
        this.fCUnit = cu;
        this.fSelection = selection;
        this.fQuery = query;
        this.fLeaveDirty = false;
    }

    public static SurroundWithTryCatchRefactoring create(IJavaScriptUnit cu, ITextSelection selection, ISurroundWithTryCatchQuery query) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(selection.getOffset(), selection.getLength()), query);
    }

    public static SurroundWithTryCatchRefactoring create(IJavaScriptUnit cu, int offset, int length, ISurroundWithTryCatchQuery query) {
        return new SurroundWithTryCatchRefactoring(cu, Selection.createFromStartLength(offset, length), query);
    }

    public void setLeaveDirty(boolean leaveDirty) {
        this.fLeaveDirty = leaveDirty;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        return exceptions == null || exceptions.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.SurroundWithTryCatchRefactoring_name;
    }

    public RefactoringStatus checkActivationBasics(JavaScriptUnit rootNode) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        this.fRootNode = rootNode;
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection, this.fQuery);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        result.merge(this.fAnalyzer.getStatus());
        return result;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        JavaScriptUnit rootNode = new RefactoringASTParser(3).parse((ITypeRoot)this.fCUnit, true, pm);
        return this.checkActivationBasics(rootNode);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new IJavaScriptUnit[]{this.fCUnit}), this.getValidationContext());
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 2);
        IPath path = this.getFile().getFullPath();
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IDocument document = bufferManager.getTextFileBuffer(path, LocationKind.IFILE).getDocument();
            CompilationUnitChange result = new CompilationUnitChange(this.getName(), this.fCUnit);
            if (this.fLeaveDirty) {
                result.setSaveMode(4);
            }
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            this.fRewriter = ASTRewrite.create((AST)this.fAnalyzer.getEnclosingBodyDeclaration().getAST());
            this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(this.fAnalyzer.getSelectedNodes(), document, this.fSelection.getOffset(), this.fSelection.getLength()));
            this.fImportRewrite = StubUtility.createImportRewrite(this.fRootNode, true);
            this.fScope = CodeScopeBuilder.perform(this.fAnalyzer.getEnclosingBodyDeclaration(), this.fSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
            this.fScope.setCursor(this.fSelection.getOffset());
            this.fSelectedNodes = this.fAnalyzer.getSelectedNodes();
            this.createTryCatchStatement(document);
            if (this.fImportRewrite.hasRecordedChanges()) {
                TextEdit edit = this.fImportRewrite.rewriteImports(null);
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{edit}));
            }
            TextEdit change = this.fRewriter.rewriteAST(document, this.fCUnit.getJavaScriptProject().getOptions(true));
            root.addChild(change);
            result.addTextEditGroup(new TextEditGroup("", new TextEdit[]{change}));
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e));
        }
        finally {
            bufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.done();
        }
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    private void createTryCatchStatement(IDocument document) throws CoreException, BadLocationException {
        String lineDelimiter = document.getLineDelimiter(0);
        ArrayList<Object> result = new ArrayList<Object>(1);
        TryStatement tryStatement = this.getAST().newTryStatement();
        ITypeBinding[] exceptions = this.fAnalyzer.getExceptions();
        int i = 0;
        while (i < exceptions.length) {
            ITypeBinding exception = exceptions[i];
            String type = this.fImportRewrite.addImport(exception);
            CatchClause catchClause = this.getAST().newCatchClause();
            tryStatement.catchClauses().add(catchClause);
            SingleVariableDeclaration decl = this.getAST().newSingleVariableDeclaration();
            String varName = StubUtility.getExceptionVariableName(this.fCUnit.getJavaScriptProject());
            String name = this.fScope.createName(varName, false);
            decl.setName(this.getAST().newSimpleName(name));
            decl.setType(ASTNodeFactory.newType(this.getAST(), type));
            catchClause.setException(decl);
            Statement st = this.getCatchBody(type, name, lineDelimiter);
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            ++i;
        }
        List variableDeclarations = this.getSpecialVariableDeclarationStatements();
        ListRewrite statements = this.fRewriter.getListRewrite((ASTNode)tryStatement.getBody(), Block.STATEMENTS_PROPERTY);
        boolean selectedNodeRemoved = false;
        ASTNode expressionStatement = null;
        int i2 = 0;
        while (i2 < this.fSelectedNodes.length) {
            ASTNode node = this.fSelectedNodes[i2];
            if (node instanceof VariableDeclarationStatement && variableDeclarations.contains(node)) {
                AST ast = this.getAST();
                VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
                VariableDeclarationStatement copy = (VariableDeclarationStatement)ASTNode.copySubtree((AST)ast, (ASTNode)statement);
                List modifiers = copy.modifiers();
                Iterator iter = modifiers.iterator();
                while (iter.hasNext()) {
                    IExtendedModifier modifier = (IExtendedModifier)iter.next();
                    if (!modifier.isModifier() || !Modifier.isFinal((int)((Modifier)modifier).getKeyword().toFlagValue())) continue;
                    iter.remove();
                }
                List fragments = copy.fragments();
                Iterator iter2 = fragments.iterator();
                Iterator original = statement.fragments().iterator();
                while (iter2.hasNext()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter2.next();
                    IVariableBinding binding = ((VariableDeclarationFragment)original.next()).resolveBinding();
                    fragment.setInitializer(null);
                }
                JavaScriptUnit root = (JavaScriptUnit)statement.getRoot();
                int extendedStart = root.getExtendedStartPosition((ASTNode)statement);
                if (extendedStart != statement.getStartPosition() && extendedStart >= this.fSelection.getOffset()) {
                    String commentToken = document.get(extendedStart, statement.getStartPosition() - extendedStart);
                    commentToken = Strings.trimTrailingTabsAndSpaces(commentToken);
                    Type type = statement.getType();
                    String typeName = document.get(type.getStartPosition(), type.getLength());
                    copy.setType((Type)this.fRewriter.createStringPlaceholder(String.valueOf(commentToken) + typeName, type.getNodeType()));
                }
                result.add(copy);
                fragments = statement.fragments();
                if (!fragments.isEmpty()) {
                    ArrayList<ExpressionStatement> newExpressionStatements = new ArrayList<ExpressionStatement>();
                    for (VariableDeclarationFragment fragment : fragments) {
                        Expression initializer = fragment.getInitializer();
                        if (initializer == null) continue;
                        Assignment assignment = ast.newAssignment();
                        assignment.setLeftHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)fragment.getName()));
                        assignment.setRightHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)initializer));
                        newExpressionStatements.add(ast.newExpressionStatement((Expression)assignment));
                    }
                    if (!newExpressionStatements.isEmpty()) {
                        if (this.fSelectedNodes.length == 1) {
                            expressionStatement = this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()]));
                        } else {
                            this.fRewriter.replace((ASTNode)statement, this.fRewriter.createGroupNode(newExpressionStatements.toArray(new ASTNode[newExpressionStatements.size()])), null);
                        }
                    } else {
                        this.fRewriter.remove((ASTNode)statement, null);
                        selectedNodeRemoved = true;
                    }
                } else {
                    this.fRewriter.remove((ASTNode)statement, null);
                    selectedNodeRemoved = true;
                }
            }
            ++i2;
        }
        result.add(tryStatement);
        ASTNode replacementNode = result.size() == 1 ? (ASTNode)result.get(0) : this.fRewriter.createGroupNode(result.toArray(new ASTNode[result.size()]));
        if (this.fSelectedNodes.length == 1) {
            if (expressionStatement != null) {
                statements.insertLast(expressionStatement, null);
            } else if (!selectedNodeRemoved) {
                statements.insertLast(this.fRewriter.createMoveTarget(this.fSelectedNodes[0]), null);
            }
            this.fRewriter.replace(this.fSelectedNodes[0], replacementNode, null);
        } else {
            ListRewrite source = this.fRewriter.getListRewrite(this.fSelectedNodes[0].getParent(), (ChildListPropertyDescriptor)this.fSelectedNodes[0].getLocationInParent());
            ASTNode toMove = source.createMoveTarget(this.fSelectedNodes[0], this.fSelectedNodes[this.fSelectedNodes.length - 1], replacementNode, null);
            statements.insertLast(toMove, null);
        }
    }

    private List getSpecialVariableDeclarationStatements() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(3);
        VariableDeclaration[] locals = this.fAnalyzer.getAffectedLocals();
        int i = 0;
        while (i < locals.length) {
            ASTNode parent = locals[i].getParent();
            if (parent instanceof VariableDeclarationStatement && !result.contains(parent)) {
                result.add(parent);
            }
            ++i;
        }
        return result;
    }

    private Statement getCatchBody(String type, String name, String lineSeparator) throws CoreException {
        String s = StubUtility.getCatchBodyContent(this.fCUnit, type, name, this.fSelectedNodes[0], lineSeparator);
        if (s == null) {
            return null;
        }
        return (Statement)this.fRewriter.createStringPlaceholder(s, 41);
    }

    private IFile getFile() {
        return (IFile)this.fCUnit.getPrimary().getResource();
    }
}

