/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.CollectingSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;

public class ReferenceFinderUtil {
    private ReferenceFinderUtil() {
    }

    public static IType[] getTypesReferencedIn(IJavaScriptElement[] elements, IProgressMonitor pm) throws JavaScriptModelException {
        SearchMatch[] results = ReferenceFinderUtil.getTypeReferencesIn(elements, null, pm);
        Set referencedTypes = ReferenceFinderUtil.extractElements(results, 7);
        return referencedTypes.toArray(new IType[referencedTypes.size()]);
    }

    public static IType[] getTypesReferencedIn(IJavaScriptElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        SearchMatch[] results = ReferenceFinderUtil.getTypeReferencesIn(elements, owner, pm);
        Set referencedTypes = ReferenceFinderUtil.extractElements(results, 7);
        return referencedTypes.toArray(new IType[referencedTypes.size()]);
    }

    private static SearchMatch[] getTypeReferencesIn(IJavaScriptElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        ArrayList referencedTypes = new ArrayList();
        pm.beginTask("", elements.length);
        int i = 0;
        while (i < elements.length) {
            referencedTypes.addAll(ReferenceFinderUtil.getTypeReferencesIn(elements[i], owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return referencedTypes.toArray(new SearchMatch[referencedTypes.size()]);
    }

    private static List getTypeReferencesIn(IJavaScriptElement element, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchEngine engine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        engine.searchDeclarationsOfReferencedTypes(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static IField[] getFieldsReferencedIn(IJavaScriptElement[] elements, IProgressMonitor pm) throws JavaScriptModelException {
        SearchMatch[] results = ReferenceFinderUtil.getFieldReferencesIn(elements, null, pm);
        Set referencedFields = ReferenceFinderUtil.extractElements(results, 8);
        return referencedFields.toArray(new IField[referencedFields.size()]);
    }

    public static IField[] getFieldsReferencedIn(IJavaScriptElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        SearchMatch[] results = ReferenceFinderUtil.getFieldReferencesIn(elements, owner, pm);
        Set referencedFields = ReferenceFinderUtil.extractElements(results, 8);
        return referencedFields.toArray(new IField[referencedFields.size()]);
    }

    private static SearchMatch[] getFieldReferencesIn(IJavaScriptElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        ArrayList referencedFields = new ArrayList();
        pm.beginTask("", elements.length);
        int i = 0;
        while (i < elements.length) {
            referencedFields.addAll(ReferenceFinderUtil.getFieldReferencesIn(elements[i], owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return referencedFields.toArray(new SearchMatch[referencedFields.size()]);
    }

    private static List getFieldReferencesIn(IJavaScriptElement element, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchEngine engine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        engine.searchDeclarationsOfAccessedFields(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static IFunction[] getMethodsReferencedIn(IJavaScriptElement[] elements, IProgressMonitor pm) throws JavaScriptModelException {
        SearchMatch[] results = ReferenceFinderUtil.getMethodReferencesIn(elements, null, pm);
        Set referencedMethods = ReferenceFinderUtil.extractElements(results, 9);
        return referencedMethods.toArray(new IFunction[referencedMethods.size()]);
    }

    public static IFunction[] getMethodsReferencedIn(IJavaScriptElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        SearchMatch[] results = ReferenceFinderUtil.getMethodReferencesIn(elements, owner, pm);
        Set referencedMethods = ReferenceFinderUtil.extractElements(results, 9);
        return referencedMethods.toArray(new IFunction[referencedMethods.size()]);
    }

    private static SearchMatch[] getMethodReferencesIn(IJavaScriptElement[] elements, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        ArrayList referencedMethods = new ArrayList();
        pm.beginTask("", elements.length);
        int i = 0;
        while (i < elements.length) {
            referencedMethods.addAll(ReferenceFinderUtil.getMethodReferencesIn(elements[i], owner, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            ++i;
        }
        pm.done();
        return referencedMethods.toArray(new SearchMatch[referencedMethods.size()]);
    }

    private static List getMethodReferencesIn(IJavaScriptElement element, WorkingCopyOwner owner, IProgressMonitor pm) throws JavaScriptModelException {
        CollectingSearchRequestor requestor = new CollectingSearchRequestor();
        SearchEngine engine = owner != null ? new SearchEngine(owner) : new SearchEngine();
        engine.searchDeclarationsOfSentMessages(element, (SearchRequestor)requestor, pm);
        return requestor.getResults();
    }

    public static ITypeBinding[] getTypesReferencedInDeclarations(FunctionDeclaration[] methods) {
        HashSet typesUsed = new HashSet();
        int i = 0;
        while (i < methods.length) {
            typesUsed.addAll(ReferenceFinderUtil.getTypesUsedInDeclaration(methods[i]));
            ++i;
        }
        return typesUsed.toArray(new ITypeBinding[typesUsed.size()]);
    }

    public static Set getTypesUsedInDeclaration(FunctionDeclaration methodDeclaration) {
        if (methodDeclaration == null) {
            return new HashSet(0);
        }
        HashSet<ITypeBinding> result = new HashSet<ITypeBinding>();
        ITypeBinding binding = null;
        Type returnType = methodDeclaration.getReturnType2();
        if (returnType != null && (binding = returnType.resolveBinding()) != null) {
            result.add(binding);
        }
        Iterator iter = methodDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            binding = ((SingleVariableDeclaration)iter.next()).getType().resolveBinding();
            if (binding == null) continue;
            result.add(binding);
        }
        iter = methodDeclaration.thrownExceptions().iterator();
        while (iter.hasNext()) {
            binding = ((Name)iter.next()).resolveTypeBinding();
            if (binding == null) continue;
            result.add(binding);
        }
        return result;
    }

    private static Set extractElements(SearchMatch[] searchResults, int elementType) {
        HashSet<IJavaScriptElement> elements = new HashSet<IJavaScriptElement>();
        int i = 0;
        while (i < searchResults.length) {
            IJavaScriptElement el = SearchUtils.getEnclosingJavaElement(searchResults[i]);
            if (el.exists() && el.getElementType() == elementType) {
                elements.add(el);
            }
            ++i;
        }
        return elements;
    }
}

