/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public final class RenameCompilationUnitChange
extends AbstractJavaElementRenameChange {
    public RenameCompilationUnitChange(IJavaScriptUnit unit, String newName) {
        this(unit.getResource().getFullPath(), unit.getElementName(), newName, -1L);
        Assert.isTrue((!unit.isReadOnly() ? 1 : 0) != 0, (String)"compilation unit must not be read-only");
    }

    private RenameCompilationUnitChange(IPath resourcePath, String oldName, String newName, long stampToRestore) {
        super(resourcePath, oldName, newName, stampToRestore);
    }

    @Override
    protected IPath createNewPath() {
        IPath path = this.getResourcePath();
        if (path.getFileExtension() != null) {
            return path.removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return path.removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) throws JavaScriptModelException {
        return new RenameCompilationUnitChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        IJavaScriptUnit cu = (IJavaScriptUnit)this.getModifiedElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameCompilationUnitChange_name, new String[]{this.getOldName(), this.getNewName()});
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 7);
    }
}

