/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameMatchRequestor;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeNameMatchCollector;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class OrganizeImportsOperation
implements IWorkspaceRunnable {
    private boolean fDoSave;
    private boolean fIgnoreLowerCaseNames;
    private IChooseImportQuery fChooseImportQuery;
    private int fNumberOfImportsAdded;
    private int fNumberOfImportsRemoved;
    private IProblem fParsingError;
    private IJavaScriptUnit fCompilationUnit;
    private JavaScriptUnit fASTRoot;
    private final boolean fAllowSyntaxErrors;

    public OrganizeImportsOperation(IJavaScriptUnit cu, JavaScriptUnit astRoot, boolean ignoreLowerCaseNames, boolean save, boolean allowSyntaxErrors, IChooseImportQuery chooseImportQuery) throws CoreException {
        this.fCompilationUnit = cu;
        this.fASTRoot = astRoot;
        this.fDoSave = save;
        this.fIgnoreLowerCaseNames = ignoreLowerCaseNames;
        this.fAllowSyntaxErrors = allowSyntaxErrors;
        this.fChooseImportQuery = chooseImportQuery;
        this.fNumberOfImportsAdded = 0;
        this.fNumberOfImportsRemoved = 0;
        this.fParsingError = null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, this.fCompilationUnit.getElementName()), 10);
            TextEdit edit = this.createTextEdit((IProgressMonitor)new SubProgressMonitor(monitor, 9));
            if (edit == null) {
                return;
            }
            JavaModelUtil.applyEdit(this.fCompilationUnit, edit, this.fDoSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    public TextEdit createTextEdit(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.fNumberOfImportsAdded = 0;
            this.fNumberOfImportsRemoved = 0;
            monitor.beginTask(Messages.format(CodeGenerationMessages.OrganizeImportsOperation_description, this.fCompilationUnit.getElementName()), 9);
            JavaScriptUnit astRoot = this.fASTRoot;
            if (astRoot == null) {
                astRoot = ASTProvider.getASTProvider().getAST((IJavaScriptElement)this.fCompilationUnit, ASTProvider.WAIT_YES, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            } else {
                monitor.worked(2);
            }
            ImportRewrite importsRewrite = StubUtility.createImportRewrite(astRoot, false);
            ArrayList typeReferences = new ArrayList();
            ArrayList staticReferences = new ArrayList();
            HashSet oldSingleImports = new HashSet();
            HashSet oldDemandImports = new HashSet();
            if (!this.collectReferences(astRoot, typeReferences, staticReferences, oldSingleImports, oldDemandImports)) {
                return null;
            }
            monitor.worked(1);
            TypeReferenceProcessor processor = new TypeReferenceProcessor(oldSingleImports, oldDemandImports, astRoot, importsRewrite, this.fIgnoreLowerCaseNames);
            for (SimpleName typeRef : typeReferences) {
                processor.add(typeRef);
            }
            boolean hasOpenChoices = processor.process((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.addStaticImports(staticReferences, importsRewrite);
            if (hasOpenChoices && this.fChooseImportQuery != null) {
                ISourceRange[] ranges;
                TypeNameMatch[][] choices = processor.getChoices();
                TypeNameMatch[] chosen = this.fChooseImportQuery.chooseImports(choices, ranges = processor.getChoicesSourceRanges());
                if (chosen == null) {
                    throw new OperationCanceledException();
                }
                int i = 0;
                while (i < chosen.length) {
                    TypeNameMatch typeInfo = chosen[i];
                    importsRewrite.addImport(typeInfo.getFullyQualifiedName());
                    ++i;
                }
            }
            TextEdit result = importsRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            this.determineImportDifferences(importsRewrite, oldSingleImports, oldDemandImports);
            TextEdit textEdit = result;
            return textEdit;
        }
        finally {
            monitor.done();
        }
    }

    private void determineImportDifferences(ImportRewrite importsStructure, Set oldSingleImports, Set oldDemandImports) {
        String importName;
        ArrayList<String> importsAdded = new ArrayList<String>();
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedImports()));
        importsAdded.addAll(Arrays.asList(importsStructure.getCreatedStaticImports()));
        Object[] content = oldSingleImports.toArray();
        int i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(importName)) {
                oldSingleImports.remove(importName);
            }
            ++i;
        }
        content = oldDemandImports.toArray();
        i = 0;
        while (i < content.length) {
            importName = (String)content[i];
            if (importsAdded.remove(String.valueOf(importName) + ".*")) {
                oldDemandImports.remove(importName);
            }
            ++i;
        }
        this.fNumberOfImportsAdded = importsAdded.size();
        this.fNumberOfImportsRemoved = oldSingleImports.size() + oldDemandImports.size();
    }

    private void addStaticImports(List staticReferences, ImportRewrite importsStructure) {
        int i = 0;
        while (i < staticReferences.size()) {
            Name name = (Name)staticReferences.get(i);
            IBinding binding = name.resolveBinding();
            if (binding != null) {
                importsStructure.addStaticImport(binding);
            }
            ++i;
        }
    }

    private boolean collectReferences(JavaScriptUnit astRoot, List typeReferences, List staticReferences, Set oldSingleImports, Set oldDemandImports) {
        IProblem curr;
        int i;
        if (!this.fAllowSyntaxErrors) {
            IProblem[] problems = astRoot.getProblems();
            i = 0;
            while (i < problems.length) {
                curr = problems[i];
                if (curr.isError() && (curr.getID() & 0x40000000) != 0) {
                    this.fParsingError = problems[i];
                    return false;
                }
                ++i;
            }
        }
        List imports = astRoot.imports();
        i = 0;
        while (i < imports.size()) {
            curr = (ImportDeclaration)imports.get(i);
            String id = ASTResolving.getFullName(curr.getName());
            if (curr.isOnDemand()) {
                oldDemandImports.add(id);
            } else {
                oldSingleImports.add(id);
            }
            ++i;
        }
        IJavaScriptProject project = this.fCompilationUnit.getJavaScriptProject();
        ImportReferencesCollector.collect((ASTNode)astRoot, project, null, typeReferences, staticReferences);
        return true;
    }

    public IProblem getParseError() {
        return this.fParsingError;
    }

    public int getNumberOfImportsAdded() {
        return this.fNumberOfImportsAdded;
    }

    public int getNumberOfImportsRemoved() {
        return this.fNumberOfImportsRemoved;
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static interface IChooseImportQuery {
        public TypeNameMatch[] chooseImports(TypeNameMatch[][] var1, ISourceRange[] var2);
    }

    private static class TypeReferenceProcessor {
        private Set fOldSingleImports;
        private Set fOldDemandImports;
        private Set fImplicitImports;
        private ImportRewrite fImpStructure;
        private boolean fDoIgnoreLowerCaseNames;
        private IPackageFragment fCurrPackage;
        private ScopeAnalyzer fAnalyzer;
        private boolean fAllowDefaultPackageImports;
        private Map fUnresolvedTypes;
        private Set fImportsAdded;
        private TypeNameMatch[][] fOpenChoices;
        private SourceRange[] fSourceRanges;

        public TypeReferenceProcessor(Set oldSingleImports, Set oldDemandImports, JavaScriptUnit root, ImportRewrite impStructure, boolean ignoreLowerCaseNames) {
            this.fOldSingleImports = oldSingleImports;
            this.fOldDemandImports = oldDemandImports;
            this.fImpStructure = impStructure;
            this.fDoIgnoreLowerCaseNames = ignoreLowerCaseNames;
            IJavaScriptUnit cu = impStructure.getCompilationUnit();
            this.fImplicitImports = new HashSet(3);
            this.fImplicitImports.add("");
            this.fImplicitImports.add("java.lang");
            this.fImplicitImports.add(cu.getParent().getElementName());
            this.fAnalyzer = new ScopeAnalyzer(root);
            this.fCurrPackage = (IPackageFragment)cu.getParent();
            this.fAllowDefaultPackageImports = cu.getJavaScriptProject().getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true).equals("1.3");
            this.fImportsAdded = new HashSet();
            this.fUnresolvedTypes = new HashMap();
        }

        private boolean needsImport(ITypeBinding typeBinding, SimpleName ref) {
            if (!typeBinding.isTopLevel() && !typeBinding.isMember() || typeBinding.isRecovered()) {
                return false;
            }
            int modifiers = typeBinding.getModifiers();
            if (Modifier.isPrivate((int)modifiers)) {
                return false;
            }
            ITypeBinding currTypeBinding = Bindings.getBindingOfParentType((ASTNode)ref);
            if (currTypeBinding == null) {
                return false;
            }
            if (!Modifier.isPublic((int)modifiers) && !currTypeBinding.getPackage().getName().equals(typeBinding.getPackage().getName())) {
                return false;
            }
            ASTNode parent = ref.getParent();
            while (parent instanceof Type) {
                parent = parent.getParent();
            }
            if (parent instanceof AbstractTypeDeclaration && parent.getParent() instanceof JavaScriptUnit) {
                return true;
            }
            return !typeBinding.isMember() || !this.fAnalyzer.isDeclaredInScope((IBinding)typeBinding, ref, 20);
        }

        public void add(SimpleName ref) {
            char ch;
            String typeName = ref.getIdentifier();
            if (this.fImportsAdded.contains(typeName)) {
                return;
            }
            IBinding binding = ref.resolveBinding();
            if (binding != null) {
                if (binding.getKind() != 2) {
                    return;
                }
                ITypeBinding typeBinding = (ITypeBinding)binding;
                if (typeBinding.isArray()) {
                    typeBinding = typeBinding.getElementType();
                }
                if (!(typeBinding = typeBinding.getTypeDeclaration()).isRecovered()) {
                    if (this.needsImport(typeBinding, ref)) {
                        this.fImpStructure.addImport(typeBinding);
                        this.fImportsAdded.add(typeName);
                    }
                    return;
                }
            } else if (this.fDoIgnoreLowerCaseNames && typeName.length() > 0 && Strings.isLowerCase(ch = typeName.charAt(0)) && Character.isLetter(ch)) {
                return;
            }
            this.fImportsAdded.add(typeName);
            this.fUnresolvedTypes.put(typeName, new UnresolvedTypeData(ref));
        }

        public boolean process(IProgressMonitor monitor) throws JavaScriptModelException {
            try {
                int nUnresolved = this.fUnresolvedTypes.size();
                if (nUnresolved == 0) {
                    return false;
                }
                char[][] allTypes = new char[nUnresolved][];
                int i = 0;
                Iterator iter = this.fUnresolvedTypes.keySet().iterator();
                while (iter.hasNext()) {
                    allTypes[i++] = ((String)iter.next()).toCharArray();
                }
                ArrayList typesFound = new ArrayList();
                IJavaScriptProject project = this.fCurrPackage.getJavaScriptProject();
                IJavaScriptSearchScope scope = SearchEngine.createJavaSearchScope((IJavaScriptElement[])new IJavaScriptElement[]{project});
                TypeNameMatchCollector collector = new TypeNameMatchCollector(typesFound);
                new SearchEngine().searchAllTypeNames(null, (char[][])allTypes, scope, (TypeNameMatchRequestor)collector, 3, monitor);
                boolean is50OrHigher = JavaModelUtil.is50OrHigher(project);
                i = 0;
                while (i < typesFound.size()) {
                    TypeNameMatch curr = (TypeNameMatch)typesFound.get(i);
                    UnresolvedTypeData data = (UnresolvedTypeData)this.fUnresolvedTypes.get(curr.getSimpleTypeName());
                    if (data != null && this.isVisible(curr) && this.isOfKind(curr, data.typeKinds, is50OrHigher) && (this.fAllowDefaultPackageImports || curr.getPackageName().length() > 0)) {
                        data.addInfo(curr);
                    }
                    ++i;
                }
                ArrayList<TypeNameMatch[]> openChoices = new ArrayList<TypeNameMatch[]>(nUnresolved);
                ArrayList<SourceRange> sourceRanges = new ArrayList<SourceRange>(nUnresolved);
                for (UnresolvedTypeData data : this.fUnresolvedTypes.values()) {
                    TypeNameMatch[] openChoice = this.processTypeInfo(data.foundInfos);
                    if (openChoice == null) continue;
                    openChoices.add(openChoice);
                    sourceRanges.add(new SourceRange(data.ref.getStartPosition(), data.ref.getLength()));
                }
                if (openChoices.isEmpty()) {
                    return false;
                }
                this.fOpenChoices = (TypeNameMatch[][])openChoices.toArray((T[])new TypeNameMatch[openChoices.size()][]);
                this.fSourceRanges = sourceRanges.toArray(new SourceRange[sourceRanges.size()]);
                return true;
            }
            finally {
                monitor.done();
            }
        }

        private TypeNameMatch[] processTypeInfo(List typeRefsFound) {
            int nFound = typeRefsFound.size();
            if (nFound == 0) {
                return null;
            }
            if (nFound == 1) {
                TypeNameMatch typeRef = (TypeNameMatch)typeRefsFound.get(0);
                this.fImpStructure.addImport(typeRef.getFullyQualifiedName());
                return null;
            }
            String typeToImport = null;
            boolean ambiguousImports = false;
            int i = 0;
            while (i < nFound) {
                TypeNameMatch typeRef = (TypeNameMatch)typeRefsFound.get(i);
                String fullName = typeRef.getFullyQualifiedName();
                String containerName = typeRef.getTypeContainerName();
                if (this.fOldSingleImports.contains(fullName)) {
                    this.fImpStructure.addImport(fullName);
                    return null;
                }
                if (this.fOldDemandImports.contains(containerName) || this.fImplicitImports.contains(containerName)) {
                    if (typeToImport == null) {
                        typeToImport = fullName;
                    } else {
                        ambiguousImports = true;
                    }
                }
                ++i;
            }
            if (typeToImport != null && !ambiguousImports) {
                this.fImpStructure.addImport(typeToImport);
                return null;
            }
            return typeRefsFound.toArray(new TypeNameMatch[nFound]);
        }

        private boolean isOfKind(TypeNameMatch curr, int typeKinds, boolean is50OrHigher) {
            return (typeKinds & 2) != 0;
        }

        private boolean isVisible(TypeNameMatch curr) {
            int flags = curr.getModifiers();
            if (Flags.isPrivate((int)flags)) {
                return false;
            }
            if (Flags.isPublic((int)flags)) {
                return true;
            }
            return curr.getPackageName().equals(this.fCurrPackage.getElementName());
        }

        public TypeNameMatch[][] getChoices() {
            return this.fOpenChoices;
        }

        public ISourceRange[] getChoicesSourceRanges() {
            return this.fSourceRanges;
        }

        private static class UnresolvedTypeData {
            final SimpleName ref;
            final int typeKinds;
            final List foundInfos;

            public UnresolvedTypeData(SimpleName ref) {
                this.ref = ref;
                this.typeKinds = ASTResolving.getPossibleTypeKinds((ASTNode)ref, true);
                this.foundInfos = new ArrayList(3);
            }

            public void addInfo(TypeNameMatch info) {
                int i = this.foundInfos.size() - 1;
                while (i >= 0) {
                    TypeNameMatch curr = (TypeNameMatch)this.foundInfos.get(i);
                    if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                        return;
                    }
                    --i;
                }
                this.foundInfos.add(info);
            }
        }
    }
}

