/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.IntersectingPattern;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class TypeReferencePattern
extends IntersectingPattern {
    protected char[] qualification;
    protected char[] simpleName;
    protected char[] currentCategory;
    public int segmentsSize;
    protected char[][] segments;
    protected int currentSegment;
    protected static char[][] CATEGORIES = new char[][]{REF};

    public TypeReferencePattern(char[] qualification, char[] simpleName, int matchRule) {
        this(matchRule);
        int index;
        if (simpleName != null && (index = CharOperation.lastIndexOf('.', simpleName)) > 0) {
            qualification = CharOperation.subarray(simpleName, 0, index);
            simpleName = CharOperation.subarray(simpleName, index + 1, simpleName.length);
        }
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        char[] cArray = this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.segments = (char[][])(simpleName == null ? (this.qualification == null ? ONE_STAR_CHAR : CharOperation.splitOn('.', this.qualification)) : null);
        this.segmentsSize = this.segments == null ? (this.qualification == null ? 0 : CharOperation.occurencesOf('.', this.qualification) + 1) : this.segments.length;
        this.mustResolve = true;
    }

    public TypeReferencePattern(char[] qualification, char[] simpleName, String typeSignature, int matchRule) {
        this(qualification, simpleName, matchRule);
        if (typeSignature != null) {
            this.typeSignatures = Util.splitTypeLevelsSignature(typeSignature);
            this.setTypeArguments(Util.getAllTypeArguments(this.typeSignatures));
            if (this.hasTypeArguments()) {
                this.segmentsSize = this.getTypeArguments().length + CharOperation.occurencesOf('/', this.typeSignatures[0]) - 1;
            }
        }
    }

    public TypeReferencePattern(char[] qualification, char[] simpleName, IType type, int matchRule) {
        this(qualification, simpleName, matchRule);
        this.storeTypeSignaturesAndArguments(type);
    }

    TypeReferencePattern(int matchRule) {
        super(4, matchRule);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        this.simpleName = key;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new TypeReferencePattern(8);
    }

    @Override
    public char[] getIndexKey() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        if (this.currentSegment >= 0) {
            return this.segments[this.currentSegment];
        }
        return null;
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    @Override
    protected boolean hasNextQuery() {
        if (this.segments == null) {
            return false;
        }
        return --this.currentSegment >= (this.segments.length >= 4 ? 2 : 0);
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    @Override
    protected void resetQuery() {
        if (this.segments != null) {
            this.currentSegment = this.segments.length - 1;
        }
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        output.append("TypeReferencePattern: qualification<");
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

