/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.util;

public class JsStringScanner {
    private String source;
    private int index;
    private int length;
    private int current;
    private StringBuilder result = new StringBuilder();

    public JsStringScanner(String source) {
        this.setSource(source);
    }

    public void setSource(String source) {
        this.source = source;
        this.index = 0;
        this.length = source.length();
        this.result.setLength(0);
    }

    public String scan() {
        this.read();
        int quote = this.current;
        if (quote != 34 && quote != 39) {
            JsStringScanner.error();
        }
        this.read();
        while (!this.isEof()) {
            if (this.current == quote) {
                return this.result.toString();
            }
            if (this.current == 92) {
                this.scanEscape();
                continue;
            }
            if (this.isEol()) {
                JsStringScanner.error();
                continue;
            }
            this.append();
            this.read();
        }
        throw new IllegalArgumentException();
    }

    private void scanEscape() {
        this.read();
        this.checkEof();
        if (this.isEol()) {
            int ch = this.current;
            this.read();
            if (ch == 13 && this.current == 10) {
                this.read();
            }
        } else {
            switch (this.current) {
                case 110: {
                    this.append('\n');
                    this.read();
                    break;
                }
                case 114: {
                    this.append('\r');
                    this.read();
                    break;
                }
                case 116: {
                    this.append('\t');
                    this.read();
                    break;
                }
                case 117: {
                    this.read();
                    this.scanUnicodeEscape();
                    break;
                }
                case 120: {
                    this.read();
                    this.scanHexDigits(2);
                    break;
                }
                case 98: {
                    this.append('\b');
                    this.read();
                    break;
                }
                case 102: {
                    this.append('\f');
                    this.read();
                    break;
                }
                case 118: {
                    this.append("\u000b");
                    this.read();
                    break;
                }
                default: {
                    if (this.current >= 48 && this.current <= 55) {
                        int code = 0;
                        int toRead = this.current >= 48 && this.current <= 51 ? 3 : 2;
                        while (toRead > 0 && this.current >= 48 && this.current <= 55) {
                            code = (code << 3) + (this.current - 48);
                            this.read();
                            this.checkEof();
                            --toRead;
                        }
                        this.append(JsStringScanner.codePointToString(code));
                        break;
                    }
                    if (this.current == 56 || this.current == 57) {
                        JsStringScanner.error();
                        break;
                    }
                    this.append();
                    this.read();
                }
            }
        }
    }

    private void scanUnicodeEscape() {
        this.checkEof();
        if (this.current == 123) {
            this.read();
            this.scanHexDigits();
            if (this.current != 125) {
                JsStringScanner.error();
            }
            this.read();
        } else {
            this.scanHexDigits(4);
        }
    }

    private void scanHexDigits() {
        int hexDigits = 0;
        while (!this.isEof()) {
            int hex = this.hexValue(true);
            if (hex == -1) break;
            if ((hexDigits = hexDigits << 4 | hex) > 0x10FFFF) {
                JsStringScanner.error();
            }
            this.read();
        }
        this.append(JsStringScanner.codePointToString(hexDigits));
    }

    private void scanHexDigits(int number) {
        int hex = 0;
        int i = 0;
        while (i < number) {
            hex = hex << 4 | this.hexValue(false);
            ++i;
            this.read();
        }
        this.append(JsStringScanner.codePointToString(hex));
    }

    private int hexValue(boolean optional) {
        if (this.current >= 48 && this.current <= 57) {
            return this.current - 48;
        }
        if (this.current >= 97 && this.current <= 102) {
            return 10 + (this.current - 97);
        }
        if (this.current >= 65 && this.current <= 70) {
            return 10 + (this.current - 65);
        }
        if (optional) {
            return -1;
        }
        throw new IllegalArgumentException();
    }

    private void read() {
        this.current = this.index < this.length ? (int)this.source.charAt(this.index++) : -1;
    }

    private void append() {
        this.result.append((char)this.current);
    }

    private void append(char ch) {
        this.result.append(ch);
    }

    private void append(String s) {
        this.result.append(s);
    }

    private static void error() {
        throw new IllegalArgumentException();
    }

    private void checkEof() {
        if (this.isEof()) {
            JsStringScanner.error();
        }
    }

    private boolean isEol() {
        return this.current == 13 || this.current == 10 || this.current == 8232 || this.current == 8233;
    }

    private boolean isEof() {
        return this.current == -1;
    }

    private static String codePointToString(int cp) {
        if (cp <= 65535) {
            return Character.toString((char)cp);
        }
        return new String(new int[]{cp}, 0, 1);
    }
}

