/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.BaseCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DefaultResponseHandler;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandOutput;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandSender;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.CommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.IncomingMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.V8ProtocolParserAccess;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessage;
import org.json.simple.JSONObject;

public class V8CommandProcessor
implements V8CommandSender<DebuggerMessage, RuntimeException> {
    private static final Logger LOGGER = Logger.getLogger(V8CommandProcessor.class.getName());
    private final V8CommandOutput messageOutput;
    private final DefaultResponseHandler defaultResponseHandler;
    private final DebugSession debugSession;
    private final BaseCommandProcessor<Integer, DebuggerMessage, IncomingMessage, CommandResponse> baseCommandProcessor;
    private static final RelayOk DISPATCH_THREAD_PROMISES_TO_CALL = new RelayOk(){};

    public V8CommandProcessor(V8CommandOutput messageOutput, DefaultResponseHandler defaultResponseHandler, DebugSession debugSession) {
        this.messageOutput = messageOutput;
        this.defaultResponseHandler = defaultResponseHandler;
        this.debugSession = debugSession;
        this.baseCommandProcessor = new BaseCommandProcessor<Integer, DebuggerMessage, IncomingMessage, CommandResponse>(new HandlerImpl());
    }

    @Override
    public RelayOk sendV8CommandAsync(DebuggerMessage message, boolean isImmediate, V8HandlerCallback v8HandlerCallback, SyncCallback syncCallback) {
        return this.baseCommandProcessor.send(message, isImmediate, v8HandlerCallback, syncCallback);
    }

    public RelayOk runInDispatchThread(final Runnable callback, final SyncCallback syncCallback) {
        Runnable innerRunnable = new Runnable(){

            @Override
            public void run() {
                RuntimeException exception = null;
                try {
                    try {
                        callback.run();
                    }
                    catch (RuntimeException e) {
                        exception = e;
                        throw e;
                    }
                }
                finally {
                    if (syncCallback != null) {
                        syncCallback.callbackDone(exception);
                    }
                }
            }
        };
        this.messageOutput.runInDispatchThread(innerRunnable);
        return DISPATCH_THREAD_PROMISES_TO_CALL;
    }

    public void processIncomingJson(JSONObject v8Json) {
        IncomingMessage response;
        try {
            response = V8ProtocolParserAccess.get().parseIncomingMessage(v8Json);
        }
        catch (JsonProtocolParseException e) {
            LOGGER.log(Level.SEVERE, "JSON message does not conform to the protocol", e);
            return;
        }
        this.baseCommandProcessor.processIncoming(response);
    }

    public void processEos() {
        this.baseCommandProcessor.processEos();
    }

    private class HandlerImpl
    implements BaseCommandProcessor.Handler<Integer, DebuggerMessage, IncomingMessage, CommandResponse> {
        private HandlerImpl() {
        }

        @Override
        public Integer getUpdatedSeq(DebuggerMessage message) {
            return message.getSeq();
        }

        @Override
        public String getCommandName(DebuggerMessage message) {
            return message.getCommand();
        }

        @Override
        public void send(DebuggerMessage message, boolean isImmediate) {
            V8CommandProcessor.this.messageOutput.send(message, isImmediate);
        }

        @Override
        public CommandResponse parseWithSeq(IncomingMessage incoming) {
            return incoming.asCommandResponse();
        }

        @Override
        public Integer getSeq(CommandResponse incomingWithSeq) {
            return (int)incomingWithSeq.requestSeq();
        }

        @Override
        public void acceptNonSeq(IncomingMessage incoming) {
            V8CommandProcessor.this.defaultResponseHandler.handleResponseWithHandler(incoming);
        }

        @Override
        public void reportVmStatus(String currentRequest, int numberOfEnqueued) {
            DebugEventListener.VmStatusListener statusListener = V8CommandProcessor.this.debugSession.getDebugEventListener().getVmStatusListener();
            if (statusListener == null) {
                return;
            }
        }
    }

    public static interface V8HandlerCallback
    extends BaseCommandProcessor.Callback<CommandResponse> {
        public static final V8HandlerCallback NULL_CALLBACK = new V8HandlerCallback(){

            @Override
            public void failure(String message) {
            }

            @Override
            public void messageReceived(CommandResponse response) {
            }
        };

        @Override
        public void messageReceived(CommandResponse var1);

        @Override
        public void failure(String var1);
    }
}

