/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolModelParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.BaseHandlersLibrary;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.MethodHandler;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.TypeHandler;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;
import org.json.simple.JSONObject;

class ParserRootImpl<R> {
    private final Class<R> rootClass;
    private final InvocationHandlerImpl invocationHandler;
    private final R instance;

    ParserRootImpl(Class<R> rootClass, Map<Class<?>, TypeHandler<?>> type2TypeHandler) throws JsonProtocolModelParseException {
        this.rootClass = rootClass;
        ParseInterfaceSession session = new ParseInterfaceSession(type2TypeHandler);
        session.run(rootClass);
        this.invocationHandler = session.createInvocationHandler();
        Object result = Proxy.newProxyInstance(rootClass.getClassLoader(), new Class[]{rootClass}, (InvocationHandler)this.invocationHandler);
        this.instance = result;
    }

    R getInstance() {
        return this.instance;
    }

    public Class<R> getType() {
        return this.rootClass;
    }

    public void writeStaticMethodJava(JavaCodeGenerator.ClassScope rootClassScope) {
        this.invocationHandler.writeStaticMethodJava(rootClassScope);
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler {
        private final Map<Method, MethodDelegate> map;

        InvocationHandlerImpl(Map<Method, MethodDelegate> map) {
            this.map = map;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return BasicUtil.getSafe(this.map, method).invoke(proxy, this, args);
        }

        public void writeStaticMethodJava(JavaCodeGenerator.ClassScope scope) {
            for (Map.Entry<Method, MethodDelegate> en : this.map.entrySet()) {
                en.getValue().writeStaticMethodJava(scope, en.getKey());
            }
        }
    }

    private static abstract class MethodDelegate {
        private MethodDelegate() {
        }

        abstract Object invoke(Object var1, InvocationHandlerImpl var2, Object[] var3) throws Throwable;

        abstract void writeStaticMethodJava(JavaCodeGenerator.ClassScope var1, Method var2);
    }

    private static class ParseDelegate
    extends MethodDelegate {
        private final TypeHandler<?> typeHandler;
        private static final String STATIC_METHOD_PARAM_NAME = "obj";
        private static final List<String> STATIC_METHOD_PARAM_NAME_LIST = Collections.singletonList("obj");

        ParseDelegate(TypeHandler<?> typeHandler) {
            this.typeHandler = typeHandler;
        }

        @Override
        Object invoke(Object proxy, InvocationHandlerImpl invocationHandlerImpl, Object[] args) throws JsonProtocolParseException {
            Object obj = args[0];
            return this.typeHandler.parseRoot(obj);
        }

        @Override
        void writeStaticMethodJava(JavaCodeGenerator.ClassScope scope, Method method) {
            MethodHandler.writeMethodDeclarationJava(scope, method, STATIC_METHOD_PARAM_NAME_LIST);
            scope.append(" throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
            scope.indentRight();
            scope.startLine("return " + scope.getTypeImplReference(this.typeHandler) + ".parse(" + STATIC_METHOD_PARAM_NAME + ");\n");
            scope.indentLeft();
            scope.startLine("}\n");
            scope.append("\n");
        }
    }

    private static class ParseInterfaceSession {
        private final Map<Class<?>, TypeHandler<?>> type2TypeHandler;
        private final Set<Class<?>> visitedInterfaces = new HashSet(1);
        private final Map<Method, MethodDelegate> methodMap = new HashMap<Method, MethodDelegate>();

        ParseInterfaceSession(Map<Class<?>, TypeHandler<?>> type2TypeHandler) {
            this.type2TypeHandler = type2TypeHandler;
        }

        void run(Class<?> clazz) throws JsonProtocolModelParseException {
            this.parseInterfaceRecursive(clazz);
            Method[] methodArray = BaseHandlersLibrary.OBJECT_METHODS;
            int n = BaseHandlersLibrary.OBJECT_METHODS.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                this.methodMap.put(method, new SelfCallDelegate(method));
                ++n2;
            }
        }

        private void parseInterfaceRecursive(Class<?> clazz) throws JsonProtocolModelParseException {
            if (BasicUtil.containsSafe(this.visitedInterfaces, clazz)) {
                return;
            }
            this.visitedInterfaces.add(clazz);
            if (!clazz.isInterface()) {
                throw new JsonProtocolModelParseException("Parser root type must be an interface: " + clazz);
            }
            JsonParserRoot jsonParserRoot = clazz.getAnnotation(JsonParserRoot.class);
            if (jsonParserRoot == null) {
                throw new JsonProtocolModelParseException(String.valueOf(JsonParserRoot.class.getCanonicalName()) + " annotation is expected in " + clazz);
            }
            Object[] objectArray = clazz.getMethods();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParseDelegate delegate;
                Method m = objectArray[n2];
                JsonParseMethod jsonParseMethod = m.getAnnotation(JsonParseMethod.class);
                if (jsonParseMethod == null) {
                    throw new JsonProtocolModelParseException(String.valueOf(JsonParseMethod.class.getCanonicalName()) + " annotation is expected in " + clazz);
                }
                Class<?>[] exceptionTypes = m.getExceptionTypes();
                if (exceptionTypes.length > 1) {
                    throw new JsonProtocolModelParseException("Too many exception declared in " + m);
                }
                if (exceptionTypes.length < 1 || exceptionTypes[0] != JsonProtocolParseException.class) {
                    throw new JsonProtocolModelParseException(String.valueOf(JsonProtocolParseException.class.getCanonicalName()) + " exception must be declared in " + m);
                }
                Type returnType = m.getGenericReturnType();
                TypeHandler<?> typeHandler = this.type2TypeHandler.get(returnType);
                if (typeHandler == null) {
                    throw new JsonProtocolModelParseException("Unknown return type in " + m);
                }
                Type[] arguments = m.getGenericParameterTypes();
                if (arguments.length != 1) {
                    throw new JsonProtocolModelParseException("Exactly one argument is expected in " + m);
                }
                Type argument = arguments[0];
                if (argument == JSONObject.class) {
                    delegate = new ParseDelegate(typeHandler);
                } else if (argument == Object.class) {
                    delegate = new ParseDelegate(typeHandler);
                } else {
                    throw new JsonProtocolModelParseException("Unrecognized argument type in " + m);
                }
                this.methodMap.put(m, delegate);
                ++n2;
            }
            objectArray = clazz.getGenericInterfaces();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object baseType = objectArray[n2];
                if (!(baseType instanceof Class)) {
                    throw new JsonProtocolModelParseException("Base interface must be class in " + clazz);
                }
                Class baseClass = (Class)baseType;
                this.parseInterfaceRecursive(baseClass);
                ++n2;
            }
        }

        InvocationHandlerImpl createInvocationHandler() {
            return new InvocationHandlerImpl(this.methodMap);
        }
    }

    private static class SelfCallDelegate
    extends MethodDelegate {
        private final Method method;

        SelfCallDelegate(Method method) {
            this.method = method;
        }

        @Override
        Object invoke(Object proxy, InvocationHandlerImpl invocationHandlerImpl, Object[] args) throws Throwable {
            try {
                return this.method.invoke((Object)invocationHandlerImpl, args);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        void writeStaticMethodJava(JavaCodeGenerator.ClassScope scope, Method method) {
        }
    }
}

