/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IPrimaryRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.events.internal.FacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class PrimaryRuntimeChangedEvent
extends FacetedProjectEvent
implements IPrimaryRuntimeChangedEvent {
    private final IRuntime oldPrimaryRuntime;
    private final IRuntime newPrimaryRuntime;

    public PrimaryRuntimeChangedEvent(IFacetedProject project, IRuntime oldPrimaryRuntime, IRuntime newPrimaryRuntime) {
        super(project, IFacetedProjectEvent.Type.PRIMARY_RUNTIME_CHANGED);
        this.oldPrimaryRuntime = oldPrimaryRuntime;
        this.newPrimaryRuntime = newPrimaryRuntime;
    }

    public IRuntime getOldPrimaryRuntime() {
        return this.oldPrimaryRuntime;
    }

    public IRuntime getNewPrimaryRuntime() {
        return this.newPrimaryRuntime;
    }

    protected void toStringInternal(StringBuilder buf) {
        buf.append("  <old-primary-runtime name=\"");
        buf.append(this.oldPrimaryRuntime == null ? "<null>" : this.oldPrimaryRuntime.getName());
        buf.append("\"/>\n");
        buf.append("  <new-primary-runtime name=\"");
        buf.append(this.newPrimaryRuntime == null ? "<null>" : this.newPrimaryRuntime.getName());
        buf.append("\"/>\n");
    }
}

