export declare type Options = {
    props?: (string | symbol)[];
    nonenumerable?: boolean;
};
/**
 * Copy (clone) an object and all its props recursively to get rid of any prop referenced of the original object. Arrays are also cloned, however objects inside arrays are still linked.
 *
 * @export
 * @template T
 * @param {T} target Target can be anything
 * @param {Options} [options = {}] Options can be `props` or `nonenumerable`
 * @returns {T} the target with replaced values
 * @export
 */
export declare function copy<T extends any>(target: T, options?: Options): T;
