/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.debug.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugElement;
import org.eclipse.viatra.transformation.debug.model.TransformationDebugTarget;
import org.eclipse.viatra.transformation.debug.model.TransformationThread;
import org.eclipse.viatra.transformation.debug.model.TransformationValue;
import org.eclipse.viatra.transformation.debug.model.TransformationVariable;
import org.eclipse.viatra.transformation.debug.model.transformationstate.ActivationParameter;
import org.eclipse.viatra.transformation.debug.model.transformationstate.RuleActivation;
import org.eclipse.viatra.transformation.debug.model.transformationstate.TransformationModelProvider;

public class TransformationStackFrame
extends TransformationDebugElement
implements IStackFrame {
    private TransformationThread thread;
    private String name;
    private IVariable[] variables;
    private final TransformationModelProvider modelProvider;

    public TransformationStackFrame(TransformationThread thread, RuleActivation activation, TransformationModelProvider modelProvider) {
        super((TransformationDebugTarget)thread.getDebugTarget());
        this.thread = thread;
        this.name = String.valueOf(activation.getRuleName()) + " : " + activation.getState();
        this.modelProvider = modelProvider;
        ArrayList transformationVariables = Lists.newArrayList();
        transformationVariables.addAll(this.createVariables(activation));
        this.variables = transformationVariables.toArray(new TransformationVariable[0]);
    }

    private List<TransformationVariable> createVariables(RuleActivation activation) {
        ArrayList createdVariables = Lists.newArrayList();
        for (ActivationParameter parameter : activation.getParameters()) {
            TransformationValue value = new TransformationValue((TransformationDebugTarget)this.getDebugTarget(), parameter.getValue(), this.modelProvider);
            TransformationVariable variable = new TransformationVariable((TransformationDebugTarget)this.getDebugTarget(), parameter.getName(), value);
            createdVariables.add(variable);
        }
        return createdVariables;
    }

    public boolean canStepInto() {
        return this.thread.canStepInto();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.thread.canStepReturn();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return Arrays.copyOf(this.variables, this.variables.length);
    }

    public boolean hasVariables() throws DebugException {
        return this.variables.length > 0;
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }
}

