/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.testing.ui.handlers;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.testing.core.ModelLoadHelper;
import org.eclipse.viatra.query.testing.core.SnapshotHelper;
import org.eclipse.viatra.query.testing.snapshot.QuerySnapshot;
import org.eclipse.viatra.query.testing.snapshot.SnapshotFactory;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;

public class SaveSnapshotHandler
extends AbstractHandler {
    @Inject
    SnapshotHelper helper;
    @Inject
    ModelLoadHelper loader;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof TreeSelection) {
            this.saveSnapshot((TreeSelection)selection, event);
        }
        return null;
    }

    private void saveSnapshot(TreeSelection selection, ExecutionEvent event) throws ExecutionException {
        Set matchers = Arrays.stream(selection.toArray()).filter(obj -> obj instanceof IFilteredMatcherContent).map(IFilteredMatcherContent.class::cast).collect(Collectors.toSet());
        ViatraQueryEngine engine = matchers.stream().findFirst().map(IFilteredMatcherContent::getMatcher).map(ViatraQueryMatcher::getEngine).orElseThrow(() -> new ExecutionException("Cannot save snapshot without ViatraQueryEngine!"));
        ResourceSet resourceSet = this.getResourceSetForScope(engine.getScope());
        if (resourceSet == null) {
            throw new ExecutionException("Cannot save snapshot, models not in ResourceSet!");
        }
        QuerySnapshot snapshot = this.getSnapshotFile(HandlerUtil.getActiveShell((ExecutionEvent)event), engine, resourceSet);
        matchers.stream().filter(m -> m.getMatcher() != null).forEach(m -> this.saveMatchesToSnapshot((IFilteredMatcherContent)m, snapshot));
        try {
            snapshot.eResource().save(null);
        }
        catch (IOException e) {
            throw new ExecutionException("Error during saving snapshot into file!", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QuerySnapshot getSnapshotFile(Shell shell, ViatraQueryEngine engine, ResourceSet resourceSet) throws ExecutionException {
        IFile snapshotFile = null;
        IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)shell, (String)"Existing snapshot", (String)"Select existing Query snapshot file (Cancel for new file)", (boolean)false, null, null);
        QuerySnapshot snapshot = null;
        if (files.length == 0) {
            snapshotFile = WorkspaceResourceDialog.openNewFile((Shell)shell, (String)"New snapshot", (String)"Select Query snapshot target file (.snapshot extension)", null, null);
            if (snapshotFile == null || snapshotFile.exists()) throw new ExecutionException("Selected file name must use .snapshot extension!");
            snapshot = SnapshotFactory.eINSTANCE.createQuerySnapshot();
            Resource res = resourceSet.createResource(URI.createPlatformResourceURI((String)snapshotFile.getFullPath().toString(), (boolean)true));
            res.getContents().add((Object)snapshot);
            return snapshot;
        } else {
            snapshotFile = files[0];
            if (snapshotFile == null || !Objects.equals(snapshotFile.getFileExtension(), "snapshot")) throw new ExecutionException("Selected file not .snapshot!");
            snapshot = this.loader.loadExpectedResultsFromFile(resourceSet, snapshotFile);
            if (snapshot == null) throw new ExecutionException("Selected file does not contain snapshot!");
            this.validateInputSpecification(engine, snapshot);
        }
        return snapshot;
    }

    private <MATCH extends IPatternMatch> void saveMatchesToSnapshot(IFilteredMatcherContent<MATCH> matcher, QuerySnapshot snapshot) {
        this.helper.saveMatchesToSnapshot(matcher.getMatcher(), matcher.getFilterMatch(), snapshot);
    }

    private void validateInputSpecification(ViatraQueryEngine engine, QuerySnapshot snapshot) throws ExecutionException {
        if (snapshot.getInputSpecification() != null) {
            Notifier root = this.helper.getEMFRootForSnapshot(snapshot);
            Notifier matcherRoot = this.getScopeRoot(engine.getScope());
            if (matcherRoot != root) {
                throw new ExecutionException("Existing snapshot model root (" + root + ") not equal to selected input (" + matcherRoot + ")!");
            }
        }
    }

    private ResourceSet getResourceSetForScope(QueryScope scope) throws ExecutionException {
        if (scope instanceof EMFScope) {
            EMFScope emfScope = (EMFScope)scope;
            Set scopeRoots = emfScope.getScopeRoots();
            if (scopeRoots.size() > 1) {
                throw new IllegalArgumentException("EMF scopes with multiple ResourceSets are not supported!");
            }
            Notifier notifier = (Notifier)scopeRoots.iterator().next();
            if (notifier instanceof EObject) {
                Resource resource = ((EObject)notifier).eResource();
                if (resource != null) {
                    return resource.getResourceSet();
                }
                return null;
            }
            if (notifier instanceof Resource) {
                return ((Resource)notifier).getResourceSet();
            }
            if (notifier instanceof ResourceSet) {
                return (ResourceSet)notifier;
            }
            return null;
        }
        throw new ExecutionException("Non-EMF scopes are not supported!");
    }

    private Notifier getScopeRoot(QueryScope scope) throws ExecutionException {
        if (scope instanceof EMFScope) {
            EMFScope emfScope = (EMFScope)scope;
            Set scopeRoots = emfScope.getScopeRoots();
            if (scopeRoots.size() > 1) {
                throw new ExecutionException("EMF scopes with multiple ResourceSets are not supported!");
            }
            return (Notifier)scopeRoots.iterator().next();
        }
        throw new ExecutionException("Non-EMF scopes are not supported!");
    }
}

