/*******************************************************************************
 * Copyright (c) 2010-2017, Dénes Harmath, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.viatra.query.testing.core.coverage

import java.util.Set
import org.eclipse.emf.common.util.URI
import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.emf.ecore.resource.ResourceSet
import org.eclipse.viatra.query.runtime.emf.EMFScope
import org.eclipse.xtend.lib.annotations.Data
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.emf.ecore.EObject

/**
 * The coverage of a PSystem element is measured within a specific scope.
 * This tuple identifies a single coverage measurement.
 */
@Data
class CoverageContext<T> {
    T element
    Set<URI> scope
    
    static def <T> CoverageContext<T> create(T element, EMFScope scope) {
        new CoverageContext(element, scope.uris)
    }
    
    private static def Set<URI> getUris(EMFScope scope) {
        scope.scopeRoots.map[
            switch it {
                Resource: #{URI}
                ResourceSet: resources.map[URI]
                EObject: #{EcoreUtil.getURI(it)}
                default: #{}
            }
        ].flatten.toSet
    }
    
}