/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.CompatibilityFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerContentGenerator;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;
import org.eclipse.ui.views.markers.internal.ProblemFilter;

public class PriorityMarkerFieldFilter
extends CompatibilityFieldFilter {
    static final int PRIORITY_HIGH = 4;
    static final int PRIORITY_NORMAL = 2;
    static final int PRIORITY_LOW = 1;
    private static final String TAG_SELECTED_PRIORITIES = "selectedPriorities";
    private static final String TAG_PRIORITY = "priority";
    int selectedPriorities = 7;

    @Override
    public void loadSettings(IMemento memento) {
        Integer priority = memento.getInteger(TAG_SELECTED_PRIORITIES);
        if (priority == null) {
            return;
        }
        this.selectedPriorities = priority;
    }

    @Override
    void loadLegacySettings(IMemento memento, MarkerContentGenerator generator) {
        String setting = memento.getString(TAG_PRIORITY);
        if (setting != null) {
            try {
                this.selectedPriorities = Integer.parseInt(setting);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Override
    public void initialize(ProblemFilter problemFilter) {
    }

    @Override
    public void saveSettings(IMemento memento) {
        memento.putInteger(TAG_SELECTED_PRIORITIES, this.selectedPriorities);
    }

    @Override
    public boolean select(MarkerItem item) {
        if (this.selectedPriorities == 0) {
            return true;
        }
        IMarker marker = item.getMarker();
        if (marker == null) {
            return false;
        }
        int markerPriority = 1 << marker.getAttribute(TAG_PRIORITY, 1);
        switch (markerPriority) {
            case 4: {
                return (this.selectedPriorities & 4) > 0;
            }
            case 2: {
                return (this.selectedPriorities & 2) > 0;
            }
            case 1: {
                return (this.selectedPriorities & 1) > 0;
            }
        }
        return true;
    }

    @Override
    public void populateWorkingCopy(MarkerFieldFilter copy) {
        super.populateWorkingCopy(copy);
        ((PriorityMarkerFieldFilter)copy).selectedPriorities = this.selectedPriorities;
    }
}

